#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include "asn1.h"
#include "acl.h"

#define TRUE 1
#define FALSE 0

static error_exit(str, linenumber, filename)
    char *str;
    int linenumber;
    char *filename;
{
    fprintf(stderr, "%s on line %d of %s\n", str, linenumber, filename);
    exit(1);
}

int
read_acl_database(filename)
    char *filename;
{
    FILE *fp;
    char buf[256], buf1[256], buf2[256], buf3[256];
    char *cp;
    int blank;
    int linenumber = 0;
    oid targetParty[64], subjectParty[64];
    int targetPartyLen, subjectPartyLen;
    int priveleges;
    struct aclEntry *ap;

    fp = fopen(filename, "r");
    if (fp == NULL)
	return 0;
    while (fgets(buf, 256, fp)){
	linenumber++;
	if (strlen(buf) > 250)
	    error_exit("Line longer than 250 bytes", linenumber, filename);
	if (buf[0] == '#')
	    continue;
	blank = TRUE;
	for(cp = buf; *cp; cp++)
	    if (!isspace(*cp)){
		blank = FALSE;
		break;
	    }
	if (blank)
	    continue;

	if (sscanf(buf, "%s %s %s", buf1, buf2, buf3) != 3)
	    error_exit("Bad parse", linenumber, filename);
	targetPartyLen = 64;
	if (!read_objid(buf1, targetParty, &targetPartyLen))
	    error_exit("Bad object identifier", linenumber, filename);

	subjectPartyLen = 64;
	if (!read_objid(buf2, subjectParty, &subjectPartyLen))
	    error_exit("Bad object identifier", linenumber, filename);

	priveleges = 0;
	for(cp = buf3; *cp; cp++){
	    switch(*cp){
	      case 'g':
	      case 'G':
		priveleges |= ACLPRIVELEGESGET;
		break;
	      case 'n':
	      case 'N':
		priveleges |= ACLPRIVELEGESGETNEXT;
		break;
	      case 'r':
	      case 'R':
		priveleges |= ACLPRIVELEGESGETRESPONSE;
		break;
	      case 's':
	      case 'S':
		priveleges |= ACLPRIVELEGESSET;
		break;
	      case 't':
	      case 'T':
		priveleges |= ACLPRIVELEGESTRAP;
		break;
	      case 'b':
	      case 'B':
		priveleges |= ACLPRIVELEGESBULK;
		break;
	      case 'i':
	      case 'I':
		priveleges |= ACLPRIVELEGESINFORM;
		break;
	      case 'u':	/* find a better letter XXXXXXXXX */
	      case 'U':
		priveleges |= ACLPRIVELEGESTRAP2;
		break;
	      default:
		error_exit("Bad priveleges code", linenumber, filename);
		break;
	    }
	}

	ap = acl_getEntry(targetParty, targetPartyLen,
			  subjectParty, subjectPartyLen);
	if (!ap)
	    ap = acl_createEntry(targetParty, targetPartyLen,
				 subjectParty, subjectPartyLen);
	ap->aclPriveleges = priveleges;
	ap->aclStatus = ACLVALID;
#define ACLCOMPLETE_MASK              15
	/* all collumns - from acl_vars.c XXX */
	ap->aclBitMask = ACLCOMPLETE_MASK;
	ap->reserved->aclBitMask = ap->aclBitMask;
    }
    fclose(fp);
    return 1;
}

