#include <sys/types.h>
#include <sys/time.h>
#include "asn1.h"
#define NULL 0
#include "acl.h"



static struct aclEntry *List = NULL, *ScanPtr = NULL;


struct aclEntry *
acl_getEntry(target, targetLen, subject, subjectLen)
    oid *target, *subject;
    int targetLen, subjectLen;
{
    struct aclEntry *ap;

    for(ap = List; ap; ap = ap->next){
        if (targetLen == ap->aclTargetLen
	    && subjectLen == ap->aclSubjectLen
	    && !bcmp((char *)ap->aclTarget, (char *)target,
		     targetLen * sizeof(oid))
	    && !bcmp((char *)ap->aclSubject, (char *)subject,
		     subjectLen * sizeof(oid)))
	    return ap;
    }
    return NULL;
}

acl_scanInit()
{
  ScanPtr = List;
}

struct aclEntry *
acl_scanNext()
{
    struct aclEntry *returnval;

    returnval = ScanPtr;
    if (ScanPtr != NULL)
        ScanPtr = ScanPtr->next;
    return returnval;
}

struct aclEntry *
acl_createEntry(target, targetLen, subject, subjectLen)
    oid *target, *subject;
    int targetLen, subjectLen;
{
    struct aclEntry *ap;

    ap = (struct aclEntry *)malloc(sizeof(struct aclEntry));
    bzero((char *)ap, sizeof(struct aclEntry));

    bcopy((char *)target, (char *)ap->aclTarget, targetLen * sizeof(oid));
    ap->aclTargetLen = targetLen;
    bcopy((char *)subject, (char *)ap->aclSubject, subjectLen * sizeof(oid));
    ap->aclSubjectLen = subjectLen;
    ap->reserved = (struct aclEntry *)malloc(sizeof(struct aclEntry));
    bzero((char *)ap->reserved, sizeof(struct aclEntry));

    ap->next = List;
    List = ap;
    return ap;
}

acl_destroyEntry(target, targetLen, subject, subjectLen)
    oid *target, *subject;
    int targetLen, subjectLen;
{
    struct aclEntry *ap, *lastap;

    if (List->aclTargetLen == targetLen
	&& List->aclSubjectLen == subjectLen
	&& !bcmp((char *)List->aclTarget, (char *)target, targetLen * sizeof(oid))
	&& !bcmp((char *)List->aclSubject, (char *)subject, subjectLen * sizeof(oid))){
	ap = List;
	List = List->next;
    } else {
	for(ap = List; ap; ap = ap->next){
	    if (ap->aclTargetLen == targetLen
		&& ap->aclSubjectLen == subjectLen
		&& !bcmp((char *)ap->aclTarget, (char *)target,
			 targetLen* sizeof(oid))
		&& !bcmp((char *)ap->aclSubject, (char *)subject,
			 subjectLen * sizeof(oid)))
		break;
	    lastap = ap;
	}
	if (!ap)
	    return;
	lastap->next = ap->next;
    }
    if (ap->reserved)
	free((char *)ap->reserved);
    free(ap);
    return;
}
