/*
 * Copyright 1992 SynOptics Communications, Inc.  All Rights Reserved.
 * SynOptics grants a non-exclusive license to use, copy, modify, and
 * distribute this software for any purpose and without fee, provided
 * that this copyright notice and license appear on all copies and
 * supporting documentation.
 * SynOptics makes no representations about the suitability of this
 * software for any particular purpose.  The software is supplied
 * "AS IS", and SynOptics makes no warranty, either express or implied,
 * as to the use, operation, condition, or performance of the software.
 * SynOptics retains all title and ownership in the software.
 *
 * file: SMWE.C - functions to print warnings and errors
 *
 * $Revision:   1.2  $ $Date:   08 Jul 1992 17:42:00  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/SMWE.C_V  $
 * 
 *    Rev 1.2   08 Jul 1992 17:42:00   gfoster
 * Removed unnecessary revision comment lines added by
 * PVCS to make revision history easier to read.
 * 
 *    Rev 1.1   19 Jun 1992 16:34:00   gfoster
 * Copyright text was reformated.
 * 
 *    Rev 1.0   27 May 1992 16:13:24   gfoster
 * Initial revision.
 *
*/

#include <stdio.h>

#ifdef MS_DOS
#include <stdlib.h>
#include <stdarg.h>
#else
#include <varargs.h>
#endif /* MS_DOS */

#include "tds.h"
#include "smscdefs.h"
#include "smstdefs.h"
#include "smsydefs.h"
#include "smic.h"


/** smwhere - print where an error occured
*
* call with:
*   pszFn - file name
*   usLineNo - line number
*   usColNo - column number
*/
    VOID
#ifdef __STDC__
smwhere(PSZ pszFn, USHORT usLineNo, USHORT usColNo)
#else
smwhere(pszFn, usLineNo, usColNo)
    PSZ pszFn;
    USHORT usLineNo;
    USHORT usColNo;
#endif /* __STDC__ */
{
    /* check if in a file */
    if (((usLineNo <= 1) && (usColNo == 0)) || (pszFn == 0))
        return;                 /* not in a file, so just return */

    /* print out file name if inside include file */
    if (pszBaseFile != pszFn)
        fprintf(fhMsg, "f(%s), ", pszFn);

    /* print line and column number */
    fprintf(fhMsg, "(%d,%d) ", usLineNo, usColNo);

} /* smwhere */


/** yywhere - print approximately where an error occured
*
*/
    VOID
#ifdef __STDC__
yywhere(VOID)
#else
yywhere()
#endif /* __STDC__ */
{
    /* check if in a file */
    if (((usLineNo <= 1) && (usColNo == 0)) || (*pszInFile == 0))
        return;                 /* not in a file, so just return */

    /* print location */
    smwhere(pszInFile, usTokLineNo, usTokColNo);

#ifdef OLD
    /* print out file name if inside include file */
    if (usInclLevel != 0)
        fprintf(fhMsg, "f(%s), ", pszInFile);

    /* print line and column number */
    fprintf(fhMsg,"(%d,%d) ", usTokLineNo, usTokColNo);
#endif

} /* yywhere */

#ifdef NEW
/** smfatal - print fatal error message and location on error file
*
* call with:
*   pszFn - file name
*   usLineNo - line number
*   usColNo - column number
*   pszMsg - message to print
*   
*/
    VOID
#ifdef __STDC__
smfatal(PSZ pszFn, USHORT usLineNo, USHORT usColNo, PSZ pszMsg, ...)
{
#else
smfatal(va_alist)
    va_dcl
{
    PSZ pszFn;
    USHORT usLineNo;
    USHORT usColNo;
    PSZ pszMsg;
#endif /* __STDC__ */
    va_list va;

    cFatal++;

    fprintf(fhMsg, "F: ");

#ifdef __STDC__
    va_start(va, pszMsg);
    smwhere(pszFn, usLineNo, usColNo);
    vfprintf(fhMsg, pszMsg, va);
#else
    va_start(va);
    pszFn = va_arg(va, PSZ);
    usLineNo = va_arg(va, USHORT);
    usColNo = va_arg(va, USHORT);
    pszMsg = va_arg(va, PSZ);
    smwhere(pszFn, usLineNo, usColNo);
    vfprintf(fhMsg, pszMsg, va);
#endif /* __STDC__ */
    fprintf(fhMsg, "\n");
    va_end(va);

} /* smfatal */


/** yyfatal - print fatal error message and location on error file
*
* call with:
*   pszMsg - message to print
*/
    VOID
#ifdef __STDC__
yyfatal(char *pszMsg, ...)
{
#else
yyfatal(va_alist)
    va_dcl
{
    PSZ pszMsg;
#endif /* __STDC__ */
    va_list va;

    cFatal++;

    fprintf(fhMsg, "F: ");

    smwhere(pszInFile, usTokLineNo, usTokColNo);

#ifdef __STDC__
    va_start(va, pszMsg);
    vfprintf(fhMsg, pszMsg, va);
#else
    va_start(va);
    pszMsg = va_arg(va, PSZ);
    vfprintf(fhMsg, pszMsg, va);
#endif /* __STDC__ */
    fprintf(fhMsg, "\n");
    va_end(va);

} /* yyfatal */
#endif


/** smerror - print error message and location on error file
*
* call with:
*   pszFn - file name
*   usLineNo - line number
*   usColNo - column number
*   pszMsg - message to print
*   
*/
    VOID
#ifdef __STDC__
smerror(PSZ pszFn, USHORT usLineNo, USHORT usColNo, PSZ pszMsg, ...)
{
#else
smerror(va_alist)
    va_dcl
{
    PSZ pszFn;
    USHORT usLineNo;
    USHORT usColNo;
    PSZ pszMsg;
#endif /* __STDC__ */
    va_list va;

    cErr++;

    fprintf(fhMsg, "E: ");

#ifdef __STDC__
    va_start(va, pszMsg);
    smwhere(pszFn, usLineNo, usColNo);
    vfprintf(fhMsg, pszMsg, va);
#else
    va_start(va);
    pszFn = va_arg(va, PSZ);
    usLineNo = va_arg(va, USHORT);
    usColNo = va_arg(va, USHORT);
    pszMsg = va_arg(va, PSZ);
    smwhere(pszFn, usLineNo, usColNo);
    vfprintf(fhMsg, pszMsg, va);
#endif /* __STDC__ */
    fprintf(fhMsg, "\n");
    va_end(va);

} /* smerror */


/** yyerror - print error message and location on error file
*
* call with:
*   pszMsg - message to print
*/
    VOID
#ifdef __STDC__
yyerror(char *pszMsg, ...)
{
#else
yyerror(va_alist)
    va_dcl
{
    PSZ pszMsg;
#endif /* __STDC__ */
    va_list va;

    cErr++;

    fprintf(fhMsg, "E: ");

    smwhere(pszInFile, usTokLineNo, usTokColNo);

#ifdef __STDC__
    va_start(va, pszMsg);
    vfprintf(fhMsg, pszMsg, va);
#else
    va_start(va);
    pszMsg = va_arg(va, PSZ);
    vfprintf(fhMsg, pszMsg, va);
#endif /* __STDC__ */
    fprintf(fhMsg, "\n");
    va_end(va);

} /* yyerror */


/** smwarning - print warning message and location on error file
*
* call with:
*   pszFn - file name
*   usLineNo - line number
*   usColNo - column number
*   pszMsg - message to print
*   
*/
    VOID
#ifdef __STDC__
smwarning(PSZ pszFn, USHORT usLineNo, USHORT usColNo, PSZ pszMsg, ...)
{
#else
smwarning(va_alist)
    va_dcl
{
    PSZ pszFn;
    USHORT usLineNo;
    USHORT usColNo;
    PSZ pszMsg;
#endif /* __STDC__ */
    va_list va;

    cWarn++;

    fprintf(fhMsg, "W: ");

#ifdef __STDC__
    va_start(va, pszMsg);
    smwhere(pszFn, usLineNo, usColNo);
    vfprintf(fhMsg, pszMsg, va);
#else
    va_start(va);
    pszFn = va_arg(va, PSZ);
    usLineNo = va_arg(va, USHORT);
    usColNo = va_arg(va, USHORT);
    pszMsg = va_arg(va, PSZ);
    smwhere(pszFn, usLineNo, usColNo);
    vfprintf(fhMsg, pszMsg, va);
#endif /* __STDC__ */
    fprintf(fhMsg, "\n");
    va_end(va);

} /* smwarning */


/** yywarning - print warning message and location on error file
*
* call with:
*   pszMsg - message to print
*/
    VOID
#ifdef __STDC__
yywarning(char *pszMsg, ...)
{
#else
yywarning(va_alist)
    va_dcl
{
    PSZ pszMsg;
#endif /* __STDC__ */
    va_list va;

    cWarn++;

    fprintf(fhMsg, "W: ");

    smwhere(pszInFile, usTokLineNo, usTokColNo);

#ifdef __STDC__
    va_start(va, pszMsg);
    vfprintf(fhMsg, pszMsg, va);
#else
    va_start(va);
    pszMsg = va_arg(va, PSZ);
    vfprintf(fhMsg, pszMsg, va);
#endif /* __STDC__ */
    fprintf(fhMsg, "\n");
    va_end(va);

} /* yywarning */


/* end of file: SMSCAN.C */
