/** file: mstrip.c - MIB stripper from Fred Baker at ACC
 *
 *
 * This file extracts the ASN.1 input text from a MIB document for
 * presentation to mosy, a MIB compiler.
 * 
 * This is useful for desk checking the MIB for correct (machine readable)
 * syntax.
 * 
 * The command line should be written:
 *
 *     mstrip <fileName>
 *
 * 
 * $Revision:   1.0  $ $Date:   28 Jul 1992 19:31:22  $
 * $Log:   R:/MIBTOOLS/V1.0/SMIC/SRC/MSTRIP.C_V  $
 * 
 *    Rev 1.0   28 Jul 1992 19:31:22   gfoster
 * Initial revision.
*/ 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef MS_DOS
#ifndef __STDC__
#define __STDC__
#endif /* __STDC__ */
#endif /* MS_DOS */

#define FALSE 0
#define TRUE ~0


char last_non_blank[8192] = "";
char last_was_blank = FALSE;
char line[8192];


    void
#ifdef __STDC__
dump_output (void)
#else
dump_output ()
#endif /* __STDC__ */
{
    if (last_non_blank[0])
        puts (last_non_blank);
    last_non_blank[0] = 0;
    if (last_was_blank)
        puts ("");
    last_was_blank = FALSE;
}

    void
#ifdef __STDC__
output (void)
#else
output ()
#endif /* __STDC__ */
{
    dump_output ();
    strcpy (last_non_blank, line);
}

char word1[512];
char word2[512];
char word3[512];
char word4[512];
    void
#ifdef __STDC__
find_begin (void)
#else
find_begin ()
#endif /* __STDC__ */
{
    if (scanf (" %s %s %s", word1, word2, word3) == 3)
        while (scanf (" %s", word4) == 1) {
            if (strcmp (word3, "::=") == 0 &&
            	  strcmp (word4, "BEGIN") == 0) {
                printf ("%s %s %s %s\n", word1, word2, word3, word4);
                return;
            } else {
                strcpy (word1, word2);
                strcpy (word2, word3);
                strcpy (word3, word4);
            }
        }
}

    int
#ifdef __STDC__
not_end (void)
#else
not_end ()
#endif /* __STDC__ */
{
    char *ptr;


    for (ptr = line; ptr[2]; ptr++)
        if (ptr[0] == 'E' &&
            ptr[1] == 'N' &&
            ptr[2] == 'D' &&
            (ptr[3] == 0 || isspace (ptr[3])) &&
            (ptr == line || isspace (ptr[-1])))
            return FALSE;
    return TRUE;
}

    char
#ifdef __STDC__
non_blank (void)
#else
non_blank ()
#endif /* __STDC__ */
{
    char *ptr;

    for (ptr = line; *ptr && isspace (*ptr); ptr++) {
        ;
    }
    return *ptr;
}

    int
#ifdef __STDC__
is_blank (char *ptr)
#else
is_blank (ptr)
    char *ptr;
#endif /* __STDC__ */
{
    for (; *ptr; ptr++) {
        if (!isspace (*ptr))
            return FALSE;
    }
    return TRUE;
}

    int
#ifdef __STDC__
get_line (void)
#else
get_line ()
#endif /* __STDC__ */
{
    if (gets (line) == 0)
        return FALSE;
    if (line[0] == '\f')
    {
        last_was_blank = FALSE;
        last_non_blank[0] = 0;
        while (get_line () && is_blank (line));
        return get_line ();
    }
    return TRUE;
}

char msg[512];

    void
#ifdef __STDC__
main (int argc, char **argv)
#else
main (argc, argv)
    int             argc;
    char          **argv;
#endif /* __STDC__ */
{
    if (argc == 2) {
        if (freopen (argv[1], "r", stdin) == NULL) {
            sprintf(msg, "Can't open file \"%s\"", argv[1]);
            perror (msg);
            exit (1);
        }
    } else {
        fprintf (stderr, "usage: mstrip <fileName>\n");
        exit (1);
    }
    find_begin ();
    while (get_line () && not_end ()) {
        if (is_blank(line))
                last_was_blank = TRUE;
        else output ();
    }
    dump_output ();
    puts ("END");
}

