/*
 * $Header: /noc/network/netlog/src/RCS/read_log.c,v 2.0 1992/05/10 16:31:11 aggarwal Exp $
 */

/* Copyright 1992 JvNCnet, Princeton University  */

/*+ 
 ** Display netlog log for any date.
 **/


/*
 * $Log: read_log.c,v $
 * Revision 2.0  1992/05/10  16:31:11  aggarwal
 * Cleaned up and restructured for releasing 'netlog v2.0'
 *
 *
 */

#ifndef lint
  static char rcsid[] = "$RCSfile: read_log.c,v $ $Revision: 2.0 $ $Date: 1992/05/10 16:31:11 $" ;
#endif

#include "netlog.h"

read_log()
{
    extern char *prognm ;
    char *reply, syscmd[MAXLINE], temp[MAXLINE],
         da[MAXWORD], mo[MAXWORD], yr[MAXWORD] ;
    time_t stamp ;				/* for getting the time	*/
    struct tm *timest ;				/* returned pointer	*/

    stamp = time((long *)NULL);
    timest = localtime ((long *)&stamp) ;

    printf("\n\n\t\t%s\n\n", "** Display Logfile **");

    sprintf(da, "%02d\0", timest->tm_mday);	
    sprintf(mo, "%02d\0", (timest->tm_mon + 1));	
    sprintf(yr, "%02d\0", timest->tm_year);	

    strncpy(mo, get_reply("Enter..\t month", mo, C_DIGIT), MAXWORD) ;
    strncpy(da, get_reply("\t date(s)", da, C_DIGIT), MAXWORD);
    strncpy(yr, get_reply("\t year", yr, C_DIGIT), MAXWORD);

    /*
     * Pipe the files through MORE instead of invoking 'MORE' on it since
     * 'MORE filename' allows a 'vi' which can cause a problem.
     */
    printf("\n\n");
    sprintf (syscmd, "%s %s/%s%s/%s.%s%s%s | %s\0", 
	     CAT, LOGDIR, mo, yr, prognm, mo, da, yr, MORE) ;

    if (debug)
      printf("(debug): system(%s)\n", syscmd) ;
    else
      return (system(syscmd)) ;

}		/* end: read_log	*/
