/*
 *	$Header: /noc/network/netlog/src/RCS/netlog.h,v 2.0 1992/05/11 16:09:09 aggarwal Exp $
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <ctype.h>
#include <errno.h>				/* doesn't def sys_errlist */
#include <string.h>
#include <stdio.h>
#ifdef ultrix
#include <time.h>
#include <unistd.h>				/* for access()		*/
#else
#include	<sys/time.h>
#endif	/* ultrix */

#include "utils.h"				/* utility routines stuff */

/****************** User customizable definitions ******************/

/*
 * Define the necessary directories. These can be defined in the Makefile
 * also. All directories can thus be defined relative to TOPDIR since the
 * program does a 'cd' to the TOPDIR.
 *
 * Define these here only if they have NOT been defined in the Makefile.
 */
#ifndef TOPDIR
#define TOPDIR	"/home/network/netlog"         /* Does a 'cd' to this     */
#endif
#ifndef BINDIR
#define BINDIR	"./bin"			/* location of local binaries	*/
#endif					/* .. added to the path */
#ifndef ETCDIR
#define ETCDIR	"./etc"			/* where all etc files stored	*/
#endif					/* ..tacked onto filenames */
#ifndef LOCKDIR
#define LOCKDIR "./locks"		/* location of all lock files	*/
#endif					/* ..tacked onto lock filenames */
#ifndef LOGDIR
#define LOGDIR	"./logs"		/* location of all log files	*/
#endif					/* ...tacked onto log file names */

/* 
 * The following are needed programs on your system. Make sure they are in
 * the path (BINPATH) and findable or else define the exact location here.
 */
#define CAT		"cat"			/* "/usr/bin/cat" */
#define COPY		"cp"			/* "/usr/bin/cp"  */
#define EDITOR		"vi"			/* "/usr/ucb/vi"  */
#define EGREP		"egrep"			/* "/usr/bin/egrep"  */
#define MAIL		"/usr/ucb/mail"		/* Allows -s and piping	*/
#define MORE		"more"			/* "/usr/ucb/more"  */
#define NROFF		"nroff"			/* "/usr/bin/nroff"  */
#define PRINTCMD	"lpr" 			/* "/usr/ucb/lpr"  */
/* #define PRINTCMD	"enscript -2r -G"	/* "/usr/local/bin/enscript -2r -G" */
#define RM		"rm -f"			/* "/usr/bin/rm -f"  */

/*
 * The following two are program specific files. They should be in the PATH,
 * else fully qualified pathnames are required. Note that the BINDIR is 
 * prepended to the PATH, so if you are installing these programs in BINDIR,
 * then you can leave these without the full pathname.
 */
#define INDEXMAIN	"netlog-indexer"
#define GREPREC		"grep_record"

/*
 * BINPATH is prepended to the path of the user when running 'netlog'. Make
 * it the bare minimum if you are giving full pathnames for all the files.
 * The code automatically prepends BINDIR to the path so the the program
 * can locate GREPREC and INDEXMAIN.
 * Don't forget terminal ':'
 */

#ifndef BINPATH
#define BINPATH  "/usr/ucb:/bin:/usr/bin:/usr/local/bin:"	/* or "" */
#endif

/*
 * OWNER of the program. Only this person can run the 'indexing' utilities.
 * Set to a real user on the system. Most probably defined in the 'Makefile'
 * as I_OWNER, that value overrides this one.
 */
#ifndef NETLOGOWNER
#define NETLOGOWNER "netlog"
#endif
#ifndef NETLOGGROUP
#define NETLOGGROUP "netlog"
#endif

/*
 * The groups that can make 'netlog' entries. If a user belongs to any
 * one of these groups, the program will change its runtime group to 
 * the 'sgid' group (the group that the program is installed under, see
 * Makefile )
 *
 * The program checks the writability of the directories and files for a
 * member of WRITE_GROUPS to be able to make an entry. A person belonging
 * to WRITE_GROUPS should be able to write to 'write_files[]'.
 *
 * If a person does not belong to one of these groups, the program does not
 * accept the 'create entry'  or 'edit' options.
 */
#define WRITE_GROUPS	"network", "netlog", "staff", NETLOGGROUP

/*
 * The 'umask' for creating all new files/dirs. Set to one of:
 *
 *		002 = no write to world
 *		007 = no read/write/execute to world
 *		027 = no write to group, no rwx to world. This means that
 *			only the owner of the directories can make entries.
 *
 * Use this to control whether anyone can read netlog and whether group can
 * write/create netlog entries.
 */
#define NETUMASK	007

/*
 * Define default 'mailer' definitions. After an entry is made, netlog prompts
 * for mailing out the entry. Enter two addresses here for prompting. Undefine
 * (or comment) them out if you don't want prompting for that address.
 */
#define PROMPTMAIL1	"netlog-staff@localhost"	/* default to mail */
#define PROMPTMAIL2	"staff@localhost"	    	/* default not mail */

/*
 * Define MAINTMAIL  to be the responsible person for getting general 
 * maintenance mail messages from this program (not '/dev/null' please)
 */
#define	MAINTMAIL	"postmaster"	/* Software maintenance	*/

/*
 * 'netlog' extracts the terminal capabilities from /etc/termcap. Some
 * terminals are very common and are present in every 'termcap', so you
 * can list those terminals here to prevent doing a lookup using 'tgetent'.
 *
 * On the other hand, there are some terminals in /etc/termcap that are
 * set by standard programs by default (like 'network' or 'ethernet', in
 * which case you might want to query the user for the terminal type
 * instead of accepting them as 'dumb' right away. List those terminals
 * here too.
 *
 */

#define GOODTERMINALS   "vt100", "vt200", "xterm", "sun"
#define BADTERMINALS    "ethernet", "network", "dialup"

/*
 * By default, netlog forks while updating the entry to the logs. Set
 * DO_FORK to 0 if you don't want it to fork. Then you have to wait while
 * it updates the logs. (Default value of '1')
 */
#define DO_FORK	1


/*
 * MAXTKTDATES is the max number of 'dates' (not entries) that any tickets
 * can have entries for. This is because the index uses fixed length size
 * records. A warning is printed when this max is reached (15 is a pretty
 * adequate value). THis is used for the 'indexing' functions.
 */
#define MAXTKTDATES     15		/* max entry dates stored	*/

/****************** Need not customize the rest. ******************/

/*
 * Define character macros (to override the SunOS supplied)
 */
#ifdef tolower
#undef tolower
#define tolower(_c) (isupper(_c)?((_c)-'A'+'a'):(_c))
#endif	/* tolower */

#ifdef toupper
#undef toupper
#define toupper(_c) (islower(_c)?((_c)-'a'+'A'):(_c))
#endif	/* toupper */

#ifndef BUFSIZ
#define BUFSIZ 1024
#endif

#define MAXLINE 1024			/* Max length of a string line */
#define MAXWORD 20			/* For scanning small words */


/*
 * All program essential files. These are created/searched for in 
 * ETCDIR.
 */
#define COOKIEJAR	"cookie-jar"	/* Jokes or fortunes as cookies	*/
#define INDEXFILE	"index"
#define INITIALSFILE	"initials"		/* names -> initials map */
#define NETLOGHDR	"netlog-header"		/* prev assigned tkt num */
#define OPENTICKETS	"open-tickets"
#define OPENTICKETHDRS	"open-tickets-summary"	/* Open ticket headers	*/
#define PREVTKT		"prev-tkt"
#define NROFFHDR	"nroff-header"		/* formatting commands	*/

/*
 * Various LOCK files to gaurantee consistency while updating. These
 * are created in LOCKDIR
 */
#define	OTLOCK		"otlock"	/* open-tickets		*/
#define	OTHLOCK		"othlock"	/* open-ticket-headers	*/
#define	PTLOCK		"ptlock"	/* previous tkt		*/
#define	LOGLOCK		"loglock"	/* Log file update	*/


/*
 * Separator for different entries (record separator)
 */
#define RECSEP  "-------------------------------------------------------------------------"
#define COOKIESEP "-----"

/*+
 *	Global symbols
 */
char **cmdline_options ;		/* command line remaining options */
char *prognm ;				/* to save the program name	*/
char *editor ;				/* Editor for creating entries	*/
char *netlog_owner ;			/* Owner of netlog program */
extern char *write_groups[] ;		/* List of groups that can write */
extern char *months[] ;			/* Abbrev list of all months */
extern char *good_terminals[] ;		/* List of good terminal types */
extern char *bad_terminals[];		/* list of bad terminal types */
uid_t ruid, euid ;			/* Program's ruid, euid and ...*/
gid_t rgid, egid ;			/* rgid, egid are saved here.  */
int  in_write_group ;			/* if user belongs to W_GROUP	*/
int  num_cmdoptions ;		     	/* Number of options remaining */
int  debug ;				/* Debugging information	*/

extern char *exec_files[], *read_files[], *write_files[], *write_dirs[];
char *Indexfile, *Initialsfile, *Netloghdr,	/* names with ETCDIR tacked */
  *Opentickets, *Opentickethdrs, *Prevtkt, *Nroffhdr ;

char *Otlock, *Othlock, *Ptlock, *Loglock ;	/* names with LOCKDIR tacked */

char *get_reply() ;			/* in utils.c */
char *tackon_dir() ;			/* in utils.c */

extern char *sys_errlist[] ;

#define Fprintf(_s)	fprintf(stderr, "%s\n", (_s))

/*
 * The highest assignable ticket value. After this ticket numbers will
 * wrap. When the ticket number reaches MAXTKT * WRAP_THRESHOLD, a mail 
 * message will be sent to MAINTMAIL to clean up the old files. All
 * ticket entries in the indexfile will be reinitialized.
 *
 * Make sure that this doesn't exceed the value of 'int' on your system.
 * 32767 is good.
 */
#define MAXTKT	30000			/* After this tickets wrap  */
#define WRAP_THRESHOLD  0.75		/* when warning is sent out */

/*
 * Define a structure which represents the entry information.
 *
 * The ttime, tnum, status, tinit and tsite all go on the same line.
 * The format is '<ttime>\t#<tnum> :<status>\t\t<tinit>\t<tsite>\n'
 * e.g.
 * 	1143    #0 :O           dh      William Patterson
 *	1517    #2070 :U                cwp     William Patterson`
 *	2253    #20071 :X               srw     Maximum of 35 chars is good
 *
 */
struct ticket_entry
{
    int 	tnum;				/* ticket number	*/
    int		tlogdir;			/* log directory mmyy	*/
    int 	tdate;				/* entry's log date	*/
    int  	ttime;				/* entry's time		*/
    char	tinit[5];			/* user's initials	*/
    char	tsite[35];			/* sitename		*/
    char	status[1];			/* entry's status	*/
    char	edtfile[MAXLINE] ;		/* Name of edited entry	*/
    char	mailrec[MAXLINE] ;	      	/* mail recipients	*/
    char 	whoami[10] ;			/* who made the entry 	*/
    char 	host[10] ;			/* from which host  	*/
    char 	asctime[10] ;			/* time of entry	*/
    char	stage[MAXLINE];			/* entry at which stage */
} ;

/*  */

/*
 * Now define the INDEXFILE stuff. Rebuild 'index' if you change any of the
 * parameters below.
 */

/*
 * Each ticket number has the following structure.
 */
struct index_entry
{
    int      	tnum ;		/* t referring to 'ticket', max 32767	*/
    u_char	numdate ;    	/* total dates for tkt (max 2**8) if 8bits */
    int	edate[MAXTKTDATES];	/* Name of the netlog files as 010390	*/
} ;

#define INDEXOFFSET(t)	(t * indexsz)	/* macro to get offset of ticket #t */
#define Numentries(n) 	((n > MAXTKTDATES) ? MAXTKTDATES : n)

