/* 	Help file for programs that deal with the AddressListType Structure */

#include "VarList.h"

#define SNMPGET 1
#define SNMPNEXT 2
#define SNMPTABLE 3

struct AddressListType {
	int SNMP_Cmd;			/* SNMPGET, SNMPNEXT, or SNMPTABLE */
        char *Address;			/* IP Address of DNS Name */
        char *Community;
		/*		These will be filled in for you	 */
	/*char *DNSName;			/* DNS Name returned */
	long LastResponded;
        unsigned long addr;             /* Binary internet address */
        struct sockaddr_in snmp_dest;   /* Who to send this to     */
        int SNMP_socket;                /* SNMP socket descriptor  */
	int Busy; 			/* Processing Response	   */
        struct VarList *QueryListHead;  /* Returned Variables      */
        struct VarList *ResponseListHead; /* Returned Variables    */
        struct AddressListType *Next;
};

/************************************************************************
 * AddAddress( ) - Add Address to AddressList				*
 *		   Returns updated AddressListHead			*
 ************************************************************************/
struct AddressListType *AddAddress();

/***************************************************************************
 * FreeAddressList() - Free all Address Structures, VarLists, and bindings *
 ***************************************************************************/
struct AddressListType *FreeAddressList();

/************************************************************************
 * FreeAddressListsVarList() - Free up this Address structures VarLists *
 ************************************************************************/
struct AddressListType *FreeAddressListsVarList();


/************************************************************************
 * MarkDone() - Mark this VarList structure as Done by removing it 	*
 *		from the QueryListHead and adding it to the ResponseList*
 ************************************************************************/
struct VarList *MarkDone();

/************************************************************************
 * Dup_Var_List_onto_AddressList() - 					*
 *	Duplicate a VarList chain onto each AddressList structure	*
 *	and Update the community field of each on eas well		*
 ************************************************************************/
void Dup_Var_List_onto_AddressList();
