/*
 * Copyright (c) 1992 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/************************************************************************
 *	MapConfig.c - Map I/O						*
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "CommonDefs.h"
#include "xmap.h"

struct MapNodeType MapNode[MAXMAPNODES];

int NumMapNodes = 1;

char *GetMapNodeName( IPAddr )
char *IPAddr;
{
	register int i;

        for (i = 1; i < NumMapNodes; i++)
                if (strcmp(IPAddr,MapNode[i].IPAddr) == 0) 
			return( MapNode[i].Name );
	return(NULL);
}

char *GetIPAddr(name)
char *name;
{
	register int i;

        for (i = 1; i < NumMapNodes; i++)
                if (strcmp(name,MapNode[i].Name ) == 0) 
			return( MapNode[i].IPAddr);
	return(NULL);
}

int GetXY(name, x, y)
char *name;
int *x, *y;
{
	register int i;

        for (i = 1; i < NumMapNodes; i++)
                if ((strcmp(name, MapNode[i].IPAddr) == 0) || 
		    (strcmp(name, MapNode[i].Name) == 0)) {
                        *x = MapNode[i].x;
                        *y = MapNode[i].y;
                        return(i);
                }
        return(0);
}

isAvailable(x, y)
int x, y;
{
	register int i;
        for (i = 1; i < NumMapNodes; i++)
		if ((MapNode[i].x == x) && (MapNode[i].y == y))
			return(1);
	return(0);
}

isViewable(ipaddr)
char *ipaddr;
{
	int x, y;

	return(GetXY(ipaddr, &x, &y));
}

void WriteMap(configfile)
char *configfile;
{
	FILE *fp;
	register int i = 0;

	fprintf(stderr, "Writing Map file to disk - %d Map Nodes\n",
								NumMapNodes);
        if ((fp = fopen(configfile,"w")) == NULL) {
                fprintf(stderr, "Couldn't write config file %s\n", configfile);
		return;
	}
	fprintf(fp, "#       Topology Config File\n");
	fprintf(fp, "#       \n");
	fprintf(fp, "#       Describes node names X,Y coordinates\n");
	fprintf(fp, "#       \n");
	fprintf(fp, "#NodeName\tIPAddr\tX\tY\n");
	for (i = 1; i < NumMapNodes; i++ )
		fprintf(fp, "%s\t%s\t%d\t%d\n", MapNode[i].Name, 
			MapNode[i].IPAddr, MapNode[i].x, MapNode[i].y);
	fclose(fp);
}

static int Xvals[]={ 0, 100, 200, 300, 400, 500, 600, 700, -1 };
static int Yvals[]={ 500, 600, 50, 100, 150, 200, 250, 300, 350, 400, 450, 
			550, 600, 650, 700, 750, 800, 850, -1 };

static int CurrentX, CurrentY;

AddMapNode(Name, IPAddr, x, y)
char *Name, *IPAddr;
int x,y;
{
	int i = NumMapNodes;
	
	if (isViewable(IPAddr)) {
		printf("This map node already exists! : %s\n", IPAddr);
		return(NumMapNodes);
	}
	if (i >= MAXMAPNODES - 1) {
		fprintf(stderr,"No Space for additional node. MAX = %d\n",
					MAXMAPNODES);
		return(NumMapNodes);
	}
	strcpy(MapNode[i].Name, Name );
	strcpy(MapNode[i].IPAddr, IPAddr);

	if (x == -1 || y == -1) {
		MapNode[i].x = Xvals[CurrentX++];
		if (Xvals[CurrentX] == -1) {
			CurrentX = 0;
			CurrentY++;
			MapNode[i].x = Xvals[CurrentX++];
		}
		MapNode[i].y = Yvals[CurrentY];
	} else {
		MapNode[i].x = x;
		MapNode[i].y = y;
	}
	return(NumMapNodes++);
}

void ReadMap(configfile)
char *configfile;
{
	FILE *fp;
	char buffer[BUFSIZ], *Name, *IPAddr, *x, *y;

        if ((fp=fopen(configfile,"r"))==NULL) {
                fprintf(stderr, "Can't read MAP FILE %s\n", configfile);
		return;
        }
        while( fgets(buffer, sizeof(buffer), fp) != NULL ) {
                if ((Name = strtok(buffer, DELIMITERS)) == NULL) 
			continue;
                if (*Name == '#' ) 
			continue;
                if ((IPAddr = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
                if ((x = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
                if ((y = strtok((char *) NULL, DELIMITERS)) == NULL) 
			continue;
		AddMapNode(Name, IPAddr, atoi(x), atoi(y));
        }
        fclose(fp);
}

