/************************************************************************
 *      Bill Norton     Enhanced SNMP API                               *
 *                                                                      *
 *      High-Level Calls:                                               *
 *              Get() - Provides a SNMP_GET for any number of hosts     *
 *              GetNext() - SNMP GET NEXT for any number of hosts       *
 *              GetTable() - SNMP GET NEXT Until End of Table           *
 *                                                                      *
 *      Each of these is called with the following parameters:          *
 *              AddressListHead - List of AddressList structures        *
 *              Community - Community Name for all queries              *
 *                          ( If NULL, it is assumed that caller        *
 *                           already set up the Community field in the  *
 *                           AddressList Structures.                 )  *
 *              QueryList - List of Variables to Query for.             *
 *                          ( If NULL, it is assumed that the caller    *
 *                           already set up the VarLists for each       *
 *                           AddressList Structures.                 )  *
 *                                                                      *
 *      If a mixture of Gets, GetNexts, and GetTables is desired, you   *
 * will have to "roll your own".  This means setting up the VarLists    *
 * and AddressList structures to accomodate your unique mix of queries. *
 *                                                                      *
 *      Comvenience Routines:                                           *
 *              To create AddressList Structures:                       *
 ************************************************************************/
#ifndef _BSD
#define _BSD 43
#endif
#include <stdio.h>
#include <stddef.h>
#include <signal.h>
#include <ctype.h>
#include <strings.h>
#include <time.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/errno.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netdb.h>
extern int verbose;
#include "Address.h"

/************************************************************************
 * SendSNMPRequest() - Send SNMP queries to hosts in AddressList struct	*
 *			provided the sockets aren't BUSY		*
 ************************************************************************/
void SendSNMPRequest();


/************************************************************************
 * BlastSNMPPackets() - For each Address in list, SendSNMPRequest	*
 *			if no response within TIMEOUT seconds		*
 ************************************************************************/
void BlastSNMPPackets( );

/************************************************************************
 * ProcessAwaitingPacket() - Receive and Process received SNMP response *
 ************************************************************************/
int ProcessAwaitingPacket();

/************************************************************************
 * ReadResponse() - Find Address struct that owns SNMP socket for which *
 *			there is a SNMP packet awaiting.		*
 ************************************************************************/
int ReadResponse();

/************************************************************************
 * Get() - Send and receive SNMP packets given:				*
 * struct AddressListType *AddressListHead - set of Addresses to Query  *
 * char *Community - community string to use with all queries		*
 * struct VarList *QueryList - a list of variables to query		*
 *	if QueryList is NULL, it is assumed that the Address VarList	*
 *	chain is already set up.					*
 ************************************************************************/
struct AddressListType *Get();

/************************************************************************
 * GetNext() - Send and receive SNMP packets given:			*
 * struct AddressListType *AddressListHead - set of Addresses to Query  *
 * char *Community - community string to use with all queries		*
 * struct VarList *QueryList - a list of variables to query		*
 *	if QueryList is NULL, it is assumed that the Address VarList	*
 *	chain is already set up.					*
 ************************************************************************/
struct AddressListType *GetNext();

/************************************************************************
 * GetTable() - Send and receive SNMP packets given:			*
 * struct AddressListType *AddressListHead - set of Addresses to Query  *
 * char *Community - community string to use with all queries		*
 * struct VarList *QueryList - a list of variables to query		*
 *	if QueryList is NULL, it is assumed that the Address VarList	*
 *	chain is already set up.					*
 ************************************************************************/
struct AddressListType *GetTable();

extern int MaxSecsB4Retry;
extern int MaxSNMPRetries;

extern char *SNMP_errormsg();	/* Returns text error message */
