/****************************************************************
 *    NetQuery.c      Network Management Interface              *
 *                                                              *
 *      This is where you can add services to exercize          *
 * Modification History						*
 * 08/08/89 - Added AppleTalk testing	@wbn1			*
 ****************************************************************/
/* 
  * Copyright 1989
  * The Regents of the University of Michigan
  * All Rights Reserved
  *
  * Permission to use, copy, modify, and distribute this software and its
  * documentation for any purpose and without fee is hereby granted, provided
  * that the above copyright notice and this permission notice appear in
  * all copies of the software and derivative works or modified versions
  * thereof, and that both that copyright notice and this permission
  * notice appear in supporting documentation.
  *
  * The software is provided "as is" and the University of Michigan
  * disclaims all warranties with regard to this software, including
  * all implied warranties of merchantability and fitness.  In no event
  * shall the University of Michigan be liable for any special, direct,
  * indirect, or consequential damages or any damages whatsoever
  * resulting from loss of use, data or profits, whether in an action of
  * contract, negligence or other tortious action, arising out of or in
  * connection with the use or performance of this software.
  */

#include "netquery.h"
#include "../INCLUDE/fileio.h"
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/file.h>

/*#define DEBUG 1 /* */
/* Add services here  and update netquery.h */
static char *NetProto[]={"NONE","PING","SGMP","SNMP","TELNET",
		 "FTP","SMTP","NAMED","TROUBLE","Empty","ATPING","ATLOOK",
		"Empty2","GENERIC"};
#define MAX_NUMBER_OF_SERVICES (sizeof(NetProto)/sizeof(char *))

static char *NetStatus[]={"ITBROKE","ITWORKS","ITDEAD"};
#define MAX_NUMBER_OF_STATUS (sizeof(NetStatus)/sizeof(char *))
/*****************************************************************
 *    Forward Declarations of Network Management layer modules   *
 *****************************************************************/
static WORD TestPING();          /* Is a node Reachable - PING   */
static WORD TestSGMP();          /*          SGMP Query          */
static WORD TestSNMP();          /*          SNMP Query          */
static WORD TestTELNET();        /*     Test TELNET services     */
static WORD TestFTP();           /*     Test FTP services        */
static WORD TestSMTP();          /*     Test SMTP services       */
static WORD TestNAMED();         /* test Name Domain Services    */
static WORD TestTROUBLE();	 /* See if mail is in TROUBLE-REPORT */
static WORD TestATPING();        /* Test Apple Talk Pingability  */ 
static WORD TestATLOOK();        /* Apple Talk GW Look for Node  */ 
static WORD TestGENERIC();	 /* Check if file exists */
				 /* Add modules Here to test services */
/*****************************************************************/

/****************************************************************************
 *      NetQuery:     Network Entity Query using/testing services           *
 *		All modules should return ITWORK, ITBROKE, or ITERROR(fatal)*
 ****************************************************************************/
WORD NetQuery(addr,tempfilename,Protocol)
char *addr;                              /* Return 0 if it Doesn't Function */
char *tempfilename;
struct NetProtoType *Protocol;		 /* Network Management protocol */
{

    if ( Protocol == NULL ) panic(" NetQuery: NULL Protocol\n");
#ifdef DEBUG
   printf("NetQuery(addr=%s,service=%s,tempfilename=%s) entering\n",
		addr,service,tempfilename);
   printf("netquery(): parms[0]=%s parms[1]=%s parms[2]=%s parms[3]=%s\n",
         Protocol->parms[0],Protocol->parms[1],Protocol->parms[2],Protocol->parms[3]);
#endif

   switch( NetService(  Protocol->parms[0] ) ) {
      case PING:   return(      TestPING( addr 			       ) );
      case SGMP:   return(      TestSGMP( 			       ) );
      case SNMP:   return(      TestSNMP(                              ) );
      case TELNET: return(    TestTELNET( addr                         ) );
      case FTP:    return(       TestFTP( addr                         ) );
      case SMTP:   return(      TestSMTP( addr                         ) );
      case NAMED:  return(     TestNAMED( addr 			       ) );
      case TROUBLE:  return( TestTROUBLE(                              ) );
      case ATPING:    return(  TestATPING(        Protocol, tempfilename ) );
      case ATLOOK:    return(  TestATLOOK(        Protocol, tempfilename ) );
      case NONE:   return( ITWORKS );
      case ERROR:   
      case GENERIC: 
      default:
 		return(       TestGENERIC( Protocol ) );
   }
}

WORD NetService( Service )
char *Service;
{
char service[100];
int i=0;

   if (Service==NULL) return(NONE);
   for(i=0; isalpha(Service[i]); i++)
	service[i]= ( isupper(Service[i]) ? Service[i] : toupper(Service[i]) ); 
   service[i]='\0';

   for(i=0; i<MAX_NUMBER_OF_SERVICES; i++)
      if (strcmp(service,NetProto[i]) == 0 ) return(i);
   return(GENERIC);
   /*printf("NetServices: Error: %s %s\n",Service,service);
   return(ERROR);*/
}


char *NetServiceString(index)
WORD index;
{
   if ( index > MAX_NUMBER_OF_SERVICES ) {
	/*fprintf(stderr,"Trying to print service #%d\n",index);*/
	return("ERROR");
   }
   return(NetProto[index]);
}

char *NetStatusString(index)
WORD index;
{
   if ( index > MAX_NUMBER_OF_STATUS ) return("ITERROR");
   return(NetStatus[index]);
}
/****************************************************************
 *	Init_netquery:	Opens error log, and saves destriptor	*
 *			in "nq_errlog", and int;		*
 ****************************************************************/
static int nq_errlog;
#define NQ_ERRLOG "/dev/null"
void init_netquery()
{
   nq_errlog = open( NQ_ERRLOG, O_RDWR|O_CREAT, 0666 );
   if ( nq_errlog < 0 )
	syserr( "Opening error log: " );
}

/****************************************************************
 *       TestPING:    Test to see if a node is up               *
 *                    Return 0 if node is DOWN                  *
 *                    Return Non-Zero if node is UP             *
 ****************************************************************/
static WORD TestPING( address )
char *address;          /* character string representing address      */
{
char	*newav[5];
extern char **environ;
int	pid;
union wait status;

#ifdef DEBUG
printf("netquery: TestPING: Address=%s\n",address);
#endif

   switch ( pid = vfork() ) {
	case -1 :	/* Fork failed */
		syserr( "vfork: ");
		/*NOTREACHED*/
	case 0 :	/* Child process */
		newav[ 0 ] = "ping (pingky)";
		newav[ 1 ] = address;
		newav[ 2 ] = "5";
		newav[ 3 ] = "5";
		newav[ 4 ] = NULL;
		dup2( nq_errlog, 0 );
		dup2( nq_errlog, 1 );
		dup2( nq_errlog, 2 );
		(void) close( nq_errlog );
#define PINGCMD "./ping"
		execve( PINGCMD, newav, environ );
		syserr( "execve: " );
		/*NOTREACHED*/
	default :	/* Parent process */
		if ( pid != wait( &status ) )
			fprintf( stderr, "Unknown child returned to me!" );
		if ( status.w_retcode != 0 ) {
			return( ITBROKE );
		} else {
			return( ITWORKS );
		}
	}
}


static WORD Tryconnect( port , addr )
char *port,*addr;
{
char    *newav[6];
extern char **environ;
int     pid;
union wait status;

#ifdef DEBUG
printf("Tryconnect: Test %s: Address=%s\n",port,addr);
#endif

   switch ( pid = vfork() ) {
        case -1 :       /* Fork failed */
                syserr( "vfork: ");
                /*NOTREACHED*/
        case 0 :        /* Child process */
                newav[ 0 ] = "connect (pingky)";
                newav[ 1 ] = "-p";
                newav[ 2 ] = port;
                newav[ 3 ] = "-h";
                newav[ 4 ] = addr;
                newav[ 5 ] = NULL;
                dup2( nq_errlog, 0 );
                dup2( nq_errlog, 1 );
                dup2( nq_errlog, 2 );
                (void) close( nq_errlog );
#define CONNECTCMD "./connect"
                execve( CONNECTCMD, newav, environ );
                syserr( "execve: " );
                /*NOTREACHED*/
        default :       /* Parent process */
                if ( pid != wait( &status ) )
                        fprintf( stderr, "Unknown child returned to me!" );
                if ( status.w_retcode != 0 ) {
                        return( ITBROKE );
                } else {
                        return( ITWORKS );
                }
        }
}

static WORD TestTELNET( addr ) /* Test TELNET services */
char *addr;
{
   return( Tryconnect( "telnet" , addr ) );
}

static WORD TestFTP( addr ) /*  Test FTP services        */
char *addr;
{
   return( Tryconnect( "ftp" , addr ) );
}

static WORD TestSMTP(addr) /*     Test SMTP services       */
char *addr;
{
   return( Tryconnect( "smtp" , addr ) );
}


static WORD TestNAMED(addr) /*   Test NAMED services       */
char *addr;
{
char    *newav[3];
extern char **environ;
int     pid;
union wait status;

#ifdef DEBUG
printf("netquery: TestNAMED: Address=%s\n",addr);
#endif

   switch ( pid = vfork() ) {
        case -1 :       /* Fork failed */
                syserr( "vfork: ");
                /*NOTREACHED*/
        case 0 :        /* Child process */
                newav[ 0 ] = "ns (pingky)";
                newav[ 1 ] = addr;
                newav[ 2 ] = NULL;
                dup2( nq_errlog, 0 );
                dup2( nq_errlog, 1 );
                dup2( nq_errlog, 2 );
                (void) close( nq_errlog );
#define NAMEDCMD "./ns"
                execve( NAMEDCMD, newav, environ );
                syserr( "execve: " );
                /*NOTREACHED*/
        default :       /* Parent process */
                if ( pid != wait( &status ) )
                        fprintf( stderr, "Unknown child returned to me!" );
                if ( status.w_retcode != 0 ) 
                        return( ITBROKE );
                else 
                        return( ITWORKS );
                /*NOTREACHED*/
		
    }
}

static WORD TestTROUBLE() /* Test MERIT TROUBLE MAIL */
{
char cmd[100];

   sprintf(cmd,"rsh merit.edu -n 'ls /usr/spool/mail/down' | grep down");
#ifdef DEBUG
     printf("TROUBLE COMMAND: %s\n",cmd);
#endif
   if ( system(cmd) ) {
      return( ITWORKS );
   }
   else {
      return( ITBROKE ); 
   }
}

static WORD TestATPING( Protocol ,tempfilename) /*  AppleTalk Pinger @wbn1*/
struct NetProtoType *Protocol;
char *tempfilename;
{
char cmd[100];

   sprintf(cmd,"atpinger %s@%s | grep 'Okay'  >%s",
		Protocol->parms[2],Protocol->parms[1],tempfilename);
#ifdef DEBUG
     printf("ATPING COMMAND: %s\n",cmd);
#endif
   return( (system(cmd)) ? 0 : 1 );
}

static WORD TestATLOOK( Protocol ,tempfilename) /*  AppleTalk Look @wbn1*/
char *tempfilename;
struct NetProtoType *Protocol;
{
char cmd[100];

   sprintf(cmd,"atlook %s | grep '%s'  >%s",
		Protocol->parms[1],Protocol->parms[2],tempfilename);
#ifdef DEBUG
     printf("ATLOOK COMMAND: %s\n",cmd);
#endif
   return( (system(cmd)) ? 0 : 1 );
}

static WORD TestSGMP( ) 
{
   return( ITWORKS );
}

static WORD TestSNMP( ) 
{
   return( ITWORKS );
}

static WORD TestGENERIC( Protocol )
struct NetProtoType *Protocol;
{
struct stat buf;

   if ( Protocol->parms[1] == NULL ) return(ITWORKS);
   if ( stat( Protocol->parms[1], &buf ) == 0 ) return ITBROKE;
   else return ITWORKS;	
 
}


