#!/bin/sh
errordir=/tmp
errortext=
error_display=cat
#error_display=crpad
echo "protocol failure at `date`" > $errordir/notify.$$
echo $* | awk '{ printf "program is %s, protocol is %s, host is %s, and error code is %s.\n", $1, $2, $3, $4}' >> /tmp/notify.$$
case "$4" in
0)	errortext="no error"
	;;
1)	errortext="connect failed"
	;;
2)	errortext="gethostbyname (nameserver query) failed"
	;;
3)	errortext="gethostbyaddr (nameserver reverse query) failed"
	;;
4)	errortext="could\'t get socket"
	;;
5)	errortext="program usage error"
	;;
6)	errortext="unknown service or port requested"
	;;
7)	errortext="name server error"
	;;
*)	errortext="unknown error $4"
esac

echo "error text is \"$errortext\"" >> /tmp/notify.$$


if test "$error_display" 
	then $error_display /tmp/notify.$$
fi

exit 0
