#!/bin/sh
#
#	wrapper to run the connect program for a variety of hosts.
#
#
#	can be set with -tcp
action=
hostlist=
donotify=
notify_program=/usr/local/lib/check/notify
tcp_checker=connect
#	can be set with -named
named_checker=ns
#	can be set with -udp
udp_checker=
#	can be set with -echo
ping_checker=/etc/ping

#	can be set with -smtp
smtp_hosts=/usr/local/lib/check/smtp.hosts
#	can be set with -telent
telnet_hosts=/usr/local/lib/check/telnet.hosts
#	can be set with -ftp
ftp_hosts=/usr/local/lib/check/ftp.hosts
#	can be set with -named
named_hosts=/usr/local/lib/check/named.hosts
#	can be set with 
ping_hosts=/usr/local/lib/check/ping.hosts
#	number of seconds to wait between iterations
delay=300
# verbosity levels.
v= vv= vvv=
#	run time options for connect
opt=
#	can be set with -log
log_file=
#	which tests to run?
S= T= F= P= Q=
on=on off=off
#	read any command line options ...

while test $# != 0
	do case "$1" in
		-udp)	udp_checker=$2
			shift ;;
		-tcp)	tcp_checker=$2
			shift ;;
		-named)	named_checker=$2
			shift ;;
		-smtp)	smtp_hosts=$2
			shift ;;
		-telnet)	telnet_hosts=$2
			shift ;;
		-ftp)	ftp_hosts=$2
			shift ;;
		-res)	named_hosts=$2
			shift ;;
		-log)	log_file=$2
			shift ;;
		-v)	opt="$opt $1"
			;;
		-vv)	vv=$on
			;;
		-vvv)	vvv=$on
			set -x
			;;
		-delay)	delay=$2
			shift ;;
		-notify)	donotify=$on
			;;
		-nprog)	notify_program=$2
			shift ;;
		-P)	P=$on
			;;
		-T)	T=$on
			;;
		-F)	F=$on
			;;
		-S)	S=$on
			;;
		-Q)	Q=$on
			;;
		-*)	echo "unknown option, $1"
			exit 1
			;;
	esac
	shift
done


# while forever ...
while /bin/true
	do
#	Do the telnet hosts
	if test "$T"
	then if test "$telnet_hosts" = "-"
		then . /usr/local/lib/check/readit
		telnet_list=$hostlist
	elif test $telnet_hosts != '' -a -f $telnet_hosts  -a -r $telnet_hosts
		then telnet_list=`cat $telnet_hosts`
	else
		if test "$vv"
		then
		echo Warning: telnet host file $telnet_hosts is not readable or does not exist.
		fi
		telnet_list=
	fi
	fi
#	Do the ftp hosts
	if test "$F"
	then if test "$ftp_hosts" = "-"
		then . /usr/local/lib/check/readit
		ftp_list=$hostlist
	elif test $ftp_hosts != '' -a -f $ftp_hosts  -a -r $ftp_hosts
		then ftp_list=`cat $ftp_hosts`
	else
	if test "$vv"
	then
		echo Warning: ftp host file $ftp_hosts is not readable or does not exist.
 	fi
		ftp_list=
	fi
	fi
#	Do the smtp hosts
	if test "$S"
	then if test "$smtp_hosts" = "-"
		then . /usr/local/lib/check/readit
		smtp_list=$hostlist
	elif test $smtp_hosts != '' -a -f $smtp_hosts  -a -r $smtp_hosts
		then smtp_list=`cat $smtp_hosts`
	else
 	if test "$vv"
 	then
		echo Warning: smtp host file $smtp_hosts is not readable or does not exist.
	fi
		smtp_list=
	fi
	fi
#	Do the name server hosts
	if test "$Q"
	then if test "$named_hosts" = "-"
		then . /usr/local/lib/check/readit
		named_list=$hostlist
	elif test $named_hosts != '' -a -f $named_hosts  -a -r $named_hosts
		then named_list=`cat $named_hosts`
	else
		if test "$vv"
		then
		echo Warning: nam server host file $named_hosts is not readable or does not exist.
		fi
		named_list=
	fi
	fi

#	Check name servers ...

	if test "$Q"
	then if test "$named_list"
	then
	if test "$vv"
	then 
	echo name server tests ...
	fi
	action=$on
	for i in $named_list
		do 
			$named_checker $opt $i
			rc=$?
			if test "$rc" != 0 -a "$donotify"
			then
			$notify_program $named_checker nameservice $i $rc
			fi
	done
	else
	if test "$vv"
	then
	echo no name server testing to do
	fi
	fi
	fi

#	Cycle through them, and see what happens.
	if test "$T"
	then if test "$telnet_list"
	then
	if test "$vv"
	then 
	echo telnet tests ...
	fi
	action=$on
	for i in $telnet_list
		do 
			$tcp_checker $opt -p telnet -h $i
			rc=$?
			if test "$rc" != 0 -a "$donotify"
			then
			$notify_program $tcp_checker telnet $i $rc
			fi
	done
	else
	if test "$vv"
	then
	echo no telnet testing to do
	fi
	fi
	fi

	if test "$F"
	then if test "$ftp_list"
	then
	if test "$vv"
	then
	echo ftp tests ...
	fi
	action=$on
	for i in $ftp_list
		do 
			$tcp_checker $opt -p ftp -h $i
			rc=$?
			if test "$rc" != 0 -a "$donotify"
			then
			$notify_program $tcp_checker ftp $i $rc
			fi
	done
	else
	if test "$vv"
	then
	echo no ftp testing to do
	fi
	fi
	fi

	if test "$S"
	then
	if test "$smtp_list"
	then
	if test "$vv"
	then
	echo smtp tests ...
	fi
	action=$on
	for i in $smtp_list
		do 
			$tcp_checker $opt -p smtp -h $i
			rc=$?
			if test "$rc" != 0 -a "$donotify"
			then
			$notify_program $tcp_checker smtp $i $rc
			fi
	done
	else
	if test "$vv"
	then
	echo no smtp testing to do.
	fi
	fi
	fi

	if test "$action" != ''
	then
	if test "$vv"
	then 
	echo sleeping ...
	fi
	sleep $delay
	else
	if test "$vv"
	then echo nothing to do this run
	fi
	exit 1
	fi

done
exit 0
