.TH XMIB 1 "20 August 1992"
.SH NAME
xmib \- MIB tree control panel for X (Motif)
.SH SYNOPSIS
.B xmib
[
.BI \-h \ hostname
] [
.BI \-c \ community
]  [
.BI \-t \ timeout
]
.if n .ti +0.5i
[
.BI \-r \ retries
] [
.BI \-p \ port
] [
.BI \-o \ root
] [
.BI \-d \ depth
]


.SH DESCRIPTION
.LP
.B xmib
provides easy SNMP control, displaying the MIB as a tree.
.LP
The
.B xmib
window is divided into four main areas:
.TP 7
.I TREE AREA
The MIB tree. The tree "grows" left to right (root is on the left).
Each tree node is a pushbutton, which represents a MIB variable and
supports the following actions, by pressing the mouse buttons:
.TP 10
Button 1 (left mouse button)
Makes node the root of the tree; if node is already
the root, makes the father of this node the new root.
.TP
Button 2 (middle mouse button)
Centers node in the tree window.
.TP
Button 3 (right mouse button)
Sends an SNMP Get Request for the variable, then updates the Variable
Area. If the node is in Expanded mode (See next action), then the
information it displays is also updated.
.TP
Button 3 double-click (right mouse button)
Toggles between Expanded/Shrunk information mode for the node:
In Shrunk mode, the node's button shows only the variable name;
In Expanded mode, the node's button shows detailed information
about the variable, similar to the information displayed
in the Parameter Area (see below). Each node can be individually
toggled between Expanded/Shrunk modes. Default mode for all nodes
is Shrunk.
.TP 7
.I PARAMETER AREA
Buttons to show and set SNMP parameters
(host, community, timeout, retries, port).
Pressing any of these buttons, opens a dialog where you can change
the parameter's value.
.TP
.I VARIABLE AREA
Shows a variable's characteristics (name, value, type, access, status).
Below appears the Set Value button that sets a variable's
value. This button becomes sensitive (ie. can be pressed) when the 
displayed variable has write permission. Pressing it opens a dialog
for value entry. After entering the value, an SNMP Set Request is
sent to the target host for the new value, followed by a Get Request.
The Variable Area updates according to the received value, so you can
see if the variable has been properly set - as soon as the cursor changes
back from the busy (watch) icon to the normal (arrow) icon.
.TP
.I CONTROL AREA
Contains several controls:
.TP 10
Depth
(slider) sets the tree depth. The slider ranges from
minDepth to maxDepth. defaultDepth is the default tree depth
(minDepth, maxDepth and defaultDepth can be set in the resource file).
.TP
Jump
(button) jumps to a specific variable in the tree.
Pressing it opens a dialog, in which you enter the desired
MIB variable name. If the entered variable exists in the
MIB tree, the tree is redisplayed with this variable as the
new root; otherwise, an error dialog appears. The Jump dialog
"remembers" the previously entered value, so you can edit
the initial text or simply reuse it.
.TP
Center Root
(button) centers the root node's button in the middle of the tree
window, if possible. You can get the same result by pressing the
middle mouse-button, inside the root node's button.
.TP
Help
(button) opens an online help window.
.TP 
Quit
(button) quits
.B xmib
immediately.


.SH OPTIONS
.LP
Options may appear in any order. Specifying an option in the
command-line overrides the default value and the value specified
in the resource file.
.RS
.TP
.BI \-h \ host
Target (controlled) host name.
.TP
.BI \-c \ community
SNMP community to use.
.TP
.BI \-t \ timeout
The interval a set/get request waits for the target host's response
before it reports failure.
.TP
.BI \-r \ retries
Number of set/get requests handled before reporting an error.
.TP
.BI \-p \ port
SNMP port to use for communication.
.TP
.BI \-o \ root
MIB variable name that serves as initial root of displayed tree.
.TP
.BI \-d \ depth
Initial depth of displayed tree.


.SH APPLICATION RESOURCES
.B xmib
declares and uses the following application-specific resources:
.LP
.TP 15
.B Xmib.root
Name of MIB variable to be the root of the tree. Default: mib-2
.TP
.B Xmib.host
Target (controlled) host name. Default: No host given
.TP
.B Xmib.community
The SNMP community to use. Default: public
.TP
.B Xmib.timeout
Communication timeout period (in sec.). Default: 5
.TP
.B Xmib.retries
Number of retries per receive/send command. Default: 3
.TP
.B Xmib.port
Port number to use for SNMP communication. Default: 161
.TP
.B Xmib.defaultDepth
Initial depth of the displayed tree. Default: 2
.TP
.B Xmib.minDepth
Minimum tree depth settable by the depth slider. Default: 1
.TP
.B Xmib.maxDepth
Maximum tree depth settable by the depth slider. Default: 7
.TP
.B Xmib.travInterval
The time (in msec.) which
.B xmib
waits before retrying to traverse to the text field of a dialog
widget. This may be helpful for for slow X-servers. Increase this
value if
.B xmib
fails to properly traverse to the text fields of dialog widgets.
Default: 0
.TP
.I Note:
The -h, -c, -t, -r, -p, -o and -d command-line options override the
Xmib.host, Xmib.community, Xmib.timeout, Xmib.retries, Xmib.port,
Xmib.root and Xmib.defaultDepth resources, respectively.


.SH WIDGETS
The hierarchy of the widgets which compose
.B xmib
: Indentation indicates hierarchical structure; The widget class
name is given first, followed by the widget instance name.
.sp
.nf
.ta .5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i
TopLevelShell  toplevel
	xmForm  mainBox
		xmScrolledWindow  scroll
			Xstree  tree  (Douglas A. Young's tree widget)
				xmPushButton  node
					.
					. (nodes which are not leaves)
					.
				xmPushButton  leaf
					.
					. (leaves)
					.
		xmForm  rightBox
			xmForm  varBox
				xmRowColumn  paramW
					xmPushButton  hostW
					xmPushButton  communityW
					xmPushButton  timeoutW
					xmPushButton  retriesW
					xmPushButton  portW
				xmLabel  varSpec
				xmPushButton  varSetButton
				xmPromptDialog  setDialog
				xmPromptDialog  paramDialog
				xmErrorDialog  warnDialog
			xmLabel  logo
			xmRowColumn  controlBox
				xmScale  scale
				xmPushButton  jumpButton
				xmPushButton  centerButton
				xmPushButton  mainHelp
				xmPushButton  mainQuit
				xmPromptDialog  jumpDialog
				xmErrorDialog  warnDialog

transientShell  helpSh
	xmForm  helpBox
		xmPushButton  helpQuit
		xmScrolledText  helpText

.fi
.LP
.I Note:
The resource name for push-buttons that represent tree leaves is
"leaf", while all other tree buttons are named "node".


.SH FILES
.PD 0
.TP 7
Note: The $(MIBDIR) variable is declared in Tricklet's Makefile.
.TP 20
.B $(MIBDIR)/mibs
list of MOSY MIB definition files
.TP
.B $(MIBDIR)/*.defs
MOSY MIB definitions files


.SH "SEE ALSO"
.LP
Manual pages of the Tricklet SNMP applications:
.LP
.BR snmp-get (1),
.BR snmp-set (1),
.BR snmp-getnext (1),
.BR snmp-table (1)
.LP
Detailed description of the tree widget can be found in the 
book "The X Window System, Programming and Applications with Xt, OSF/MOTIF
Edition" by Douglas A. Young, which is the author of the tree widget.


.SH BUGS
-\ xmib does not support SNMP tables in any way. The release version
will (hopefully) fix this.
.LP
-\ The traversal problem is solved in an ugly way.
.LP
-\ xmib might crash if the user "wildly" redraws the xmib tree (ie.
presses the left mouse button very rapidly).


.SH AUTHOR
Ranen Goren, Dept. of Computer Science, the Hebrew University of
Jerusalem, ISRAEL.
.LP
Please feel free to send anything regarding xmib to ranen@cs.huji.ac.il .
This includes suggestions, remarks, bug fixes (send me patches only),
criticism, etc.
