/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
File:    xmib.h
System:  xmib ver. 1.00
Author:  Ranen Goren
Date:    20/07/92

File remarks: header file for the xmib package
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/


typedef struct _dentry DENTRY;

struct _dentry
{
    char *name;
    int value;
};

static DENTRY mibType[] =
{
  {"DisplayString",128},
  {"TimeTicks",7},
  {"Counter",5},
  {"Aggregate",16},
  {"INTEGER", 1},
  {"Gauge",6},
  {"OctetString",2},
  {"ObjectID",3},
  {"NetworkAddress",18},
  {"IpAddress",4},
  {NULL,0}
};

static DENTRY mibMode[] =
{
  {"read-only",1},
  {"write-only",2},
  {"read-write",3},
  {"not-accessible",0},
  {NULL, 0}
};

static DENTRY mibStatus[] =
{
  {"mandatory",1},
  {"deprecated",2},
  {"optional",3},
  {NULL,0}
};



typedef struct snmpParamsStruct
{
    char  *root;
    char  *host;
    char  *community;
    int   timeout;
    int   retries;
    int   port;
    int   min_depth;
    int   max_depth;
    int   default_depth;
    int   travInterval;
}  SNMP_PARAMS, *snmpParamsPtr;




enum {
	UPDATE_HOST,
	UPDATE_COMMUNITY,
	UPDATE_TIMEOUT,
	UPDATE_RETRIES,
	UPDATE_PORT
};




#define  max(x, y)  ((x)>=(y) ? (x) : (y))
#define  min(x, y)  ((x)<=(y) ? (x) : (y))

#ifdef DEBUG
#define safefree(x)  { if (x) free(x); else fprintf(stderr, "free(NULL) !!!\n"); }
#else
#define safefree(x)  free(x)
#endif




void    main();
MIBNODE *snmpOpen();
void    snmpClose();
int     snmpCall();
void    MibShowXTree();
void    fillTree();
void    quit();
void    initWidgets();
void    startMainLoop();
void    newTree();
void    redrawTree();
void    updateVar();
void    node2text();
void    centerRoot();
void    setVarValue();
void    okSetVarValue();
Widget  dispSnmpParams();
void    updateParams();
void    checkCommandLine();
void    warn();
void    warnOk();
void    centerNode();
void    centerNodeTran();
void    flashWidget();
void    timedInvertWidgetColors();
void    invertWidgetColors();
void    jumpRequest();
void    jumpRequestOk();
void    logoHighlight();
void    setParamValue();
void    setParamValueOk();
void    gotoTextField();
void    openHelp();
void    closeHelp();
