/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       tit.c
**     SYSTEM   NAME:       SNMP Timeticks Module
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1990/11/28
**
** DESCRIPTION: SNMP Timeticks Module
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header$";
#endif
#include <stdio.h>
#include <time.h>

static long
    TitBeg;

/**************************************************************
** NAME:        TitIni                                    [API]
** SYNOPSIS:    void
**                  TitIni
**                  (
**                      void
**                  )
** DESCRIPTION: Initializes TitBeg to current time.
** RETURNS:     nothing
**************************************************************/
void
    TitIni
    (
        void
    )
{
    TitBeg = time (NULL);
}

/**************************************************************
** NAME:        TitGet                                    [API]
** SYNOPSIS:    unsigned long
**                  TitGet
**                  (
**                      void
**                  )
** DESCRIPTION: Returns hundreths of seconds sinds TitIni.
** RETURNS:     hundreths of seconds sinds TitIni.
**************************************************************/
unsigned long
    TitGet
    (
        void
    )
{
    return ((time (NULL) - TitBeg) * 100);
}
