/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       main.c
**     SYSTEM   NAME:       mib
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       
**
** DESCRIPTION: Test routines for mib module
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#include <stdio.h>
#include <dnpap.h>
#include <protot.h>
#include "mib.h"

void DumpTree __((char *name));

int main(int argc,char **argv)
{
    int id[24],id2[24],idnr,i,nrmatched;
    char *name;

    /* check arguments */
    if(argc!=2)
    {
	fprintf(stderr, "run as:  %s <MIB-name>\n",argv[0]);
	exit(1);
    }

    /* initialise the MIB system */
    MibInit();
    

    MibFullMib();
    /* work with the API */
    name = argv[1];
    idnr = MibName2ID(id,name);


    if(idnr<0)
    {
	fprintf(stderr,"cant find %s\n",name);
	exit(1);
    }
    /*prepare a longer id */
    for(i=0;i<idnr;i++) id2[i]=id[i];
    id2[idnr] = 100;
    id2[idnr+1] = 101;

    name = MibID2Name2(id2,idnr+2,&nrmatched);
    if(name!=NULL)
    {
	printf("longer id matched <%s,%d>\n",name,nrmatched);
    }

    printf("%s = ",name);for(i=0;i<idnr;i++) printf("%d.",id[i]); printf("\n");
    printf("%s ?= %s\n",name, MibID2Name(id,idnr));
    printf("type = %d,%d\n",MibIDType(id,idnr),MibNameType(name));
    printf("type = %d,%d\n",MibIDMode(id,idnr),MibNameMode(name));
    printf("type = %d,%d\n",MibIDStatus(id,idnr),MibNameStatus(name));

    /* DumpTree(name); */
    return 0;
}

void DumpTree(char *name)
{
    char *chld;

    if(name==NULL) return;

    printf("%s\n",name);

    chld = MibGetFirstChild(name);

    while(chld != NULL)
    {
	DumpTree(chld);
	chld = MibGetNextChild(chld);
    }
}
