.TH Tricklet 1 local
.SH NAME
snmp-table \- SNMP-table command
.SH SYNOPSIS
.B snmp-table <host>
[
.B <community> <timeout> <retries> <port> 
] file
.SH DESCRIPTION
.I snmp-table
collects a subtree of snmp variables starting at the given mib
variable. One line of input will normally generate a list of output
lines, each line containg one node of the subtree.
snmp-table send one snmp GET command for the root of the subtree, and
snmp GETNEXT commands to collect the nodes in the subtree.
.br
By adding three dots ('...') to a request line, snmp-table will
collect in each output line the values of the requested mib varaible
and all its alpha-numerically higher brothers. In this way, a table of
mib variables can be collected, with each output line containing one
row of the table.
.br
See the man page of snmp-get for a syntax of a request.
.SH EXAMPLES
The following example retrieves the mib variable 'ifInErrors' 
from the snmp agent on host dnpap.et.tuddelft.nl:
.br

\<-- echo "ifInErrors" | snmp-table dnpap.et.tudelft.nl
.br
--\> ifInErrors[1]=0
.br
--\> ifInErrors[2]=263
.br

The next example shows the use of a table:
.br
\<-- echo "ifInErrors[]..." | snmp-table dnpap.et.tudelft.nl
.br
--\> ifInErrors[1]=0; ifInUnknownProtos[1]=0; ifOutOctets[1]=0; \/
.br
ifOutUcastPkts[1]=19708; ifOutNUcastPkts[1]=0; ifOutDiscards[1]=0; \/
.br
fOutErrors[1]=0; ifOutQLen[1]=0; ifSpecific[1]=0.0 
.br
--\> ifInErrors[2]=263; ifInUnknownProtos[2]=0; ifOutOctets[2]=0; \/
.br
ifOutUcastPkts[2]=6824440; ifOutNUcastPkts[2]=0; ifOutDiscards[2]=0; \/
.br
ifOutErrors[2]=984463; ifOutQLen[2]=0; ifSpecific[2]=0.0

.SH FILES
$(MIBHOME)/mibs		list of MOSY MIB definition files
$(MIBHOME)/*.defs	     MOSY MIB definitions files
.br
$(BIN)/snmp-table		executable
.SH SEE ALSO
.IR snmp-get(l)
.IR snmp-set(l)
.IR snmp-getnext(l)
.br
