.TH Tricklet 1 local
.SH NAME
snmp-get \- SNMP-get command
.SH SYNOPSIS
.B snmp-get <host>
[
.B <community> <timeout> <retries> <port> 
] file
.SH DESCRIPTION
.I snmp-get
send snmp GET requests to the snmp agent on the specified host.
snmp-get reads line from stdin and interprets each line as a group of
snmp get requests seperated by semicolons. Such a group is send as one
SNMP message to the host. Seperate lines are send as
seperate snmp messages. Output of snmp-get is send to stdout.
.br
The format of the input to snmp-get is the same as the output
generated by snmp-get.

.SH DEFAULTS

community == "public"
.br
timeout == 5 secs
.br
retries == 3
.br
port == 161

.SH INPUT FORMAT
an input-line has the following format:

<mibvar>[=<value>][;<mibvar>[=<value>]] 

or:

<mibvar> ...

where <mibvar> is the identifier of the requested mib
variable and <value> its future value. Since snmp-get only requests
values, the <value> part has no meaning.
.br
.SH MIB VARIABLES
A mibvar consists of a logical name defined in a MOSY MIB
definition file, an optional index and an optional table requestor
'...'.
.br
If a mibvar is followed by three dots (...), the value of
this variable and all its alpha-numerically higher brothers will be
requested as a group. This is usefull when retrieving tables of
values. See the example for more information.
.br
A mibvar can contain an index, given as a dot seperated
number list encapulated in square brackets, just like a C array index.
This index will be added to the mib number of mibvar.
An incomplete mib number will be interpreted as a request for a whole
subtree starting at the given mib number. Each node in this subtree is
returned as a seperate output line. 

.SH VALUES
The tricklet library displays and accepts values in a human readable
form. 
Each mib variable has a defined type, and the tricklet library converts the
human readable value to the defined type of the mib variable. 
.br
The following variable type are accepted/displayed by the tricklet library:

printable string: > "an example string"
.br
octet string: >     1e:2f:00
.br
id: >               1.2.3.4.5.6.7.8
.br
integer: > 	    123456


.SH EXAMPLES
The following example retrieves the mib variable 'sysDescr' 
(system description) from the snmp agent on host dnpap.et.tuddelft.nl:
.br

\<-- echo "sysDescr" | snmp-get dnpap.et.tudelft.nl
.br
--\> sysDescr[0]="a string"
.br

The following example retrieves variables 'sysDescr' and 'sysName' in
one snmp request. The result is returned as one line. 
.br

\<-- echo "sysDescr;sysName" | snmp-get dnpap.et.tudelft.nl
.br
--\> sysDescr[0]="a string";sysName[0]="dnpap"
.br

The next example shows that the output of one command can be used as
input for a next command:
.br

\<-- echo "sysDescr" | snmp-get dnpap | snmp-getnext dnpap
.br
--\> sysObjectID[0]=1.3.6.1.4.1.42.2.1.1
.br

.SH FILES
$(MIBHOME)/mibs		list of MOSY MIB definition files
$(MIBHOME)/*.defs	     MOSY MIB definitions files
.br
$(BIN)/snmp-get		executable
.SH SEE ALSO
.IR snmp-getnext(1)
.IR snmp-set(1)
.IR snmp-table(1)
.br
