/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       exec.c
**     SYSTEM   NAME:       tricklet
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION  NUMBER:     
**     CREATION DATE:       
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision$
** AUTHOR:   $Author$
** DATE:     $Date$
** LOG:      $Log$
*************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <dnpap.h>
#include <snmp.h>
#include <mib.h>
#include <stdarg.h>
#include <err.h>
#include "parse.h"



char *SNMP_Errors[]=
{
    "No Error",					/* PKT_NOERROR */
    "To many SNMP varaibles in one request",	/* PKT_TOOBIG */
    "No such MIB variable",			/* PKT_NOSUCHNAME */
    "Illegal value",				/* PKT_BADVALUE */
    "Attempt to write READONLY MIB variable",	/* PKT_READONLY */
    "Unknown SNMP error"			/* PKT_GENERR */
};
/**
* execute an snmp command
*	type = PKT_GETRQS --> snmp-get
*	type = PKT_SETRQS --> snp-set
*	type = PKT_NXTRQS --> snmp-getnext
*	type = PKT_TBLRQS --> snmp-table
**/

int snmp_exec(int argc, char **argv,int type)
{
	char host[80];
	char community[80];
	unsigned long timeout;
	unsigned long retries;
	mgt_sck	*handle;
	pkt_msg message;
	int port;
	char line[256];
	int table[256];
	int tableLength;
	int r;

	
	
	if(argc<2)
	{
	    ERR_ERR(
		    1,
		    ERR_CRITICAL,
		    "usage: %s <host> [<community> <timeout> <retries> <port>]\n",
		    argv[0]);
	}
	strcpy(host,argv[1]);
	if(argc>=3)
		strcpy(community,argv[2]);
	else
		strcpy(community,"public");
	if(argc>=4)
		timeout=atol(argv[3]);
	else
		timeout=5000000L;
	if(argc>=5)
		retries=atoi(argv[4]);
	else
		retries=3;
        if(argc>=6)
		port=atoi(argv[5]);
	else
		port=161;
	if((handle=MgtOpn(htons(161), MgtAdr(host))) == NULL)
        {
	    ERR_ERR(
		    2,
		    ERR_CRITICAL,
		    "Opening SNMP port to %s failed\n",
		    host);
        }	
	if (MibInit()!=0)
	{
	    ERR_ERR(
		    3,
		    ERR_CRITICAL,
		    "Mib initialisation failed\n"
		    );
	}

	/* read the MIB files */
	MibFullMib();

 	while(gets(line))
	{
		if(GetList(line,message.MsgPdu.PduRor.RorLst,PKT_SZERORLST,
			(int *) &message.MsgPdu.PduRor.RorLstLen)<0)
		{
		    ERR_ERR(
			    4,
			    ERR_CRITICAL,
			    "Couldn't parse <%s>\n",
			    line
			    );
		}
		tableLength=message.MsgPdu.PduRor.RorLst[0].ObjOjiLen;
		memcpy(table,message.MsgPdu.PduRor.RorLst[0].ObjOji,tableLength*sizeof(int));
		while(1)
		{
		    strcpy(message.MsgCom, community);
		    message.MsgComLen=strlen(community);
		    if (type == PKT_TBLRQS)
		      message.MsgPdu.PduRor.RorTyp=PKT_NXTRQS;
		    else
		      message.MsgPdu.PduRor.RorTyp=type;
		    message.MsgPdu.PduRor.RorRid=0;
		    message.MsgPdu.PduRor.RorErrSts=PKT_NOERROR;
		    message.MsgPdu.PduRor.RorErrInd=0;
		    if(MgtRqs(handle,&message,timeout,retries)<0)
		    {
			ERR_ERR(
				5,
				ERR_CRITICAL,
				"SNMP request failed, to many retries\n"
				);
		    }
		    if(type == PKT_TBLRQS)
		      if (memcmp(table, message.MsgPdu.PduRor.RorLst[0].ObjOji,
				tableLength*sizeof(int))!=0 ||
				message.MsgPdu.PduRor.RorErrSts == PKT_NOSUCHNAME)
				break;

		    if (message.MsgPdu.PduRor.RorErrSts!=PKT_NOERROR)
		    {
			if ((r=PutIdentifier(
				message.MsgPdu.PduRor.RorLst+message.MsgPdu.PduRor.RorErrInd-1,
				line,sizeof(line)
					    ))<0)
				line[0]='\0';
			else
				line[r]='\0';
			ERR_ERR(
				6,
				ERR_CRITICAL,
				"SNMP error: <%s>, variable %d, %s\n",
				SNMP_Errors[message.MsgPdu.PduRor.RorErrSts],
				message.MsgPdu.PduRor.RorErrInd,
				line
				);
		    }
		    if(PutList(message.MsgPdu.PduRor.RorLst,message.MsgPdu.PduRor.RorLstLen,
					line,sizeof(line))<0)
		    {
			ERR_ERR(
				6,
				ERR_CRITICAL,
				"Couldn't handle result list\n"
				);
		    }
		    puts(line);
		    if(type != PKT_TBLRQS)
		      break;
		}
	}
	MgtCls(handle);
	return 0;
}

