
#include <signal.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <PopScrText.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>



static char* colors [] = {
    "green", "red", "blue", "tan" };

#define N_LINES 64
extern int n_lines;
extern int highlight [N_LINES];
extern char lines [N_LINES][64];
Widget toplevel, boxlevel,  widgets[N_LINES];
void Refresh();
void ButtonClick();
int debug;

int i;
void  catch_signal()
{
int i;

    /*fprintf (stderr, "SIGNALLED\n");*/
    if (read_data(FALSE))  Rewrite();
    alarm (2);
}

void SetWMHints()
{	static int width, height, top, left;
	static Arg text_args[] = {
		{XtNfontWidth, (XtArgVal) &width}, 
		{XtNfontHeight,(XtArgVal) &height},
		{XtNtopMargin, (XtArgVal) &top},
		{XtNleftMargin, (XtArgVal) &left},
	};
	static Arg shell_args[] = {
		{XtNwidthInc, 0},
		{XtNheightInc, 0},
		{XtNminWidth, 0},
		{XtNminHeight, 0},
	};
	XtGetValues(widgets[0], text_args, XtNumber(text_args));
	shell_args[0].value = (XtArgVal)width;
	shell_args[1].value = (XtArgVal)height;
	shell_args[2].value = (XtArgVal)left;
	shell_args[3].value = (XtArgVal)top;

	XtSetValues(toplevel, shell_args, XtNumber(shell_args));
}

void ButtonClick (w,client,call)
Widget w;
caddr_t client, call;
{
    XpwCallMethod(w, XpwMBell);
}

void KeyHit(w,client,call)
Widget w;
caddr_t client, call;
{
	int key = (int) call;
	KeySym ks = (KeySym) abs(key);
        unsigned int method = XpwMSetFont;
        char *new_text = NULL;
        char *color = NULL;
	static int row, col;

	if (key < 0 || IsModifierKey(key)) return;

	switch (ks) {
		case XK_Left: 	   method=XpwMCursorLeft;	break;
		case XK_Right: 	   method=XpwMCursorRight; 	break;
		case XK_Up: 	   method=XpwMCursorUp;		break;
		case XK_Down:	   method=XpwMCursorDown;	break;
		case XK_Return:    ButtonClick(w,0,1);		break;
		case XK_BackSpace: ButtonClick(w,0,3); 		break;
		case XK_Q:
		case XK_q:	   exit(0);
		case XK_g:	   color = "Green"; break;
		case XK_B:	   new_text = "Blue"; break;
		case XK_Y:	   new_text = "Yellow"; break;
		case XK_G:	   new_text  ="Green"; break;

		default:	   method=XpwMBell;     	break;

	}

	if (new_text) {
           for (i=0; i< N_LINES; i++ ){
                sprintf (lines[i], "%s LINE number %d _", new_text, i);
           }
           Rewrite();
	}
	if (color) {
           for (i=0; i< n_lines; i++ ){
		XpwCallMethod(widgets[i], XpwMSetColor, color);
		XpwCallMethod(widgets[i], XpwMClearWindow);
           }
	}
	else if (method != XpwMSetFont)
		XpwCallMethod(w, method);
}

void Refresh(w,client,call)
Widget w;
caddr_t client;
caddr_t call;
{       
        Rewrite();
}

void main(argc,argv)
unsigned int argc;
char **argv;
{
	static XtCallbackRec keyCallbacks[] = {
		{ KeyHit, NULL },
		{ NULL, NULL},
	};
	static XtCallbackRec refreshCallbacks[] = {
		{ Refresh, NULL },
		{ NULL, NULL},
	};

	static XtCallbackRec buttonCallbacks[] = {
		{ ButtonClick, NULL },
		{ NULL, NULL},
	};
	static Arg textArgs[] = {
		{ XtNpopCallback, (XtArgVal)refreshCallbacks },
		/*{ XtNkeyboardEvent, (XtArgVal)keyCallbacks},*/
		/*{ XtNbuttonEvent, (XtArgVal)buttonCallbacks },*/
		{ XtNnumRows, (XtArgVal)1 },
		{ XtNnumColumns, (XtArgVal)30 },
                { XtNvSpace, (XtArgVal)0 },
	};
	int i; short *foo;
        signal (SIGUSR1, (*catch_signal));
        signal (SIGALRM, (*catch_signal));
 
        connect_server();
        read_data(TRUE);
        printf ("No of lines: %d \n", n_lines);

	toplevel = (Widget)XtInitialize("text", "Text", NULL,0, &argc, argv);

        boxlevel = XtCreateManagedWidget ("box", boxWidgetClass, toplevel,
          textArgs, XtNumber(textArgs));

        for (i=0; i< n_lines; i++) {
	    widgets[i]=(Widget)XtCreateManagedWidget("popscrtext",
		popScrollTextWidgetClass,
		boxlevel, textArgs, XtNumber(textArgs));
            /*XpwCallMethod(widgets[i], XpwMSetColor, colors[i]);*/
        }
	SetWMHints();
        alarm (2);
	XtRealizeWidget(toplevel);
	XtMainLoop();
}

Rewrite () {
   for (i =0; i< n_lines; i++) {
         XpwCallMethod(widgets[i], XpwMSetColor, colors[highlight[i]]);
         XpwCallMethod(widgets[i], XpwMWriteLine, 0,0, lines[i],0,FALSE);
   }

}
