

#include <sys/types.h>
#include <stdio.h>

#include "data.h"

extern struct node *getnode();


main() {

    FILE *setup_file;
    struct node *current_node,*nodelist;

    /* Read in the setup file allocating the node structures as neccessary */
    if ((setup_file = fopen("test.setup", "r")) ==  NULL) {
        perror("snmpstatus: setup-file");
	exit(1);
    }

    if (!feof(setup_file)) {
        nodelist = getnode(setup_file);
	current_node = nodelist;
        while (!feof(setup_file)) {
	    current_node->next = getnode(setup_file);
	    current_node = current_node->next;
        }
    }


    /* now dump everything */
    current_node = nodelist;
    while (current_node != NULL) {
        printf("%s %s %d %d %s %d %d %d\n",
	       current_node->name,
	       current_node->community,
	       current_node->timeout,
	       current_node->ifdown,
	       current_node->sysdes ? current_node->sysdes : "NULL",
	       current_node->uptime,
	       current_node->iflist,
	       current_node->next);
	current_node = current_node->next;
    }
}

