#ifndef SNMP
#define SNMP

#ifdef __STDC__
#define __(x) x
#else
#define __(x)  ()
#endif

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <time.h>
#include "asn1.h"


void TitIni __( ( void ) );
unsigned long TitGet __( ( void ) );

#ifdef IPS_DOS
#include <socket.h>
#define IPS_SCK             SOCKET
#define IPS_CLS             closesocket
#define IPS_ERR             NULL
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#define IPS_SCK             int
#define IPS_CLS             close
#define IPS_ERR             -1
#endif
#define IPS_ADR                 struct sockaddr
#define IPS_IPA                 struct sockaddr_in

#define AUT_SZECOM              255

typedef struct _aut_net
{
    long            NetAdr;
    long            NetMsk;
    struct _aut_net *NetNxt;
}
    aut_net;

typedef struct _aut_srv
{
    char            SrvCom [AUT_SZECOM];
    unsigned        SrvComLen;
    aut_net         *SrvNet;
    int             (*SrvEnc) __((asn_sck  *Asn));
    int             (*SrvDec) __((asn_sck  *Asn));
    struct _aut_srv *SrvNxt;
}
    aut_srv;

typedef struct
{
    aut_srv         *SckSrv;
    long unsigned   SckBadCom;
    long unsigned   SckBadUse;
}
    aut_sck;

extern aut_sck
    AutSck;

aut_srv *AutAddSrv __( ( char        *Com, unsigned    ComLen, int         (*Enc) (asn_sck  *Asn), int         (*Dec) (asn_sck  *Asn) ) );
int AutAddNet __( ( aut_srv     *Srv, long        Adr, long        Msk ) );

#define PKT_SZECOM              255
#define PKT_SZEOJI              63
#ifndef MAX_SNMP_VAR
#define PKT_SZERORLST           16
#else
#define PKT_SZERORLST           MAX_SNMP_VAR
#endif
#define PKT_SZETRPLST           3
#define PKT_SZESYNCHR           255
#define PKT_SZESYNINT           63

#define PKT_NOERROR             0
#define PKT_TOOBIG              1
#define PKT_NOSUCHNAME          2
#define PKT_BADVALUE            3
#define PKT_READONLY            4
#define PKT_GENERR              5

#define PKT_NULL                0
#define PKT_INTEGER             1    /* SynLngInt */
#define PKT_OCTETSTRING         2    /* SynBufChr */
#define PKT_OBJECTIDENTIFIER    3    /* SynBufInt */
#define PKT_IPADDRESS           4    /* SynLngUns */
#define PKT_COUNTER             5    /* SynLngUns */
#define PKT_GAUGE               6    /* SynLngUns */
#define PKT_TIMETICKS           7    /* SynLngUns */
#define PKT_OPAQUE              8    /* SynBufChr */

#define PKT_GETRQS              0
#define PKT_NXTRQS              1
#define PKT_GETRSP              2
#define PKT_SETRQS              3
#define PKT_TRP                 4

#define PKT_COLDSTART           0
#define PKT_WARMSTART           1
#define PKT_LINKDOWN            2
#define PKT_LINKUP              3
#define PKT_AUTFAILURE          4
#define PKT_EGPNEIGHBORLOSS     5
#define PKT_ENTSPECIFIC         6

typedef union
{
    int             SynInt;
    long            SynLngInt;
    unsigned        SynUns;
    long unsigned   SynLngUns;
    char            SynBufChr [PKT_SZESYNCHR];
    unsigned        SynBufInt [PKT_SZESYNINT];
}
    pkt_syn;

typedef struct
{
    unsigned        ObjOji [PKT_SZEOJI];
    unsigned        ObjOjiLen;
    int             ObjTag;
    pkt_syn         ObjSyn;
    unsigned        ObjSynLen;
}
    pkt_obj;

typedef struct
{
    unsigned        RorTyp;
    long unsigned   RorRid;
    unsigned        RorErrSts;
    unsigned        RorErrInd;
    pkt_obj         RorLst [PKT_SZERORLST];
    unsigned        RorLstLen;
}
    pkt_ror;

typedef struct
{
    unsigned        TrpTyp;
    unsigned        TrpOji [PKT_SZEOJI];
    unsigned        TrpOjiLen;
    long unsigned   TrpIpa;
    unsigned        TrpGen;
    unsigned        TrpSpe;
    long unsigned   TrpTit;
    pkt_obj         TrpLst [PKT_SZETRPLST];
    unsigned        TrpLstLen;
}
    pkt_trp;

typedef union
{
    unsigned        PduTyp;
    pkt_trp         PduTrp;
    pkt_ror         PduRor;
}
    pkt_pdu;

typedef struct
{
    char            MsgCom [PKT_SZECOM];
    unsigned        MsgComLen;
    pkt_pdu         MsgPdu;
}
    pkt_msg;

typedef struct
{
    long unsigned   SckOutPkts;
    long unsigned   SckOutTooBigs;
    long unsigned   SckOutNoSuchNames;
    long unsigned   SckOutBadValues;
    long unsigned   SckOutReadOnlys;
    long unsigned   SckOutGenErrs;
    long unsigned   SckOutGetRequests;
    long unsigned   SckOutGetNexts;
    long unsigned   SckOutSetRequests;
    long unsigned   SckOutGetResponses;
    long unsigned   SckOutTraps;
    long unsigned   SckInPkts;
    long unsigned   SckInTooBigs;
    long unsigned   SckInNoSuchNames;
    long unsigned   SckInBadValues;
    long unsigned   SckInReadOnlys;
    long unsigned   SckInGenErrs;
    long unsigned   SckInGetRequests;
    long unsigned   SckInGetNexts;
    long unsigned   SckInSetRequests;
    long unsigned   SckInGetResponses;
    long unsigned   SckInTraps;
    long unsigned   SckInBadVersions;
    long unsigned   SckInASNParseErrs;
    long unsigned   SckInBadTypes;
}
    pkt_sck;

extern pkt_sck
    PktSck;

#define AGT_SZECOM  255
#define AGT_SZEOJI  63
#define AGT_SZEPKT  1024

typedef struct
{
    int             SckIni;
    int             SckOpn;
    IPS_SCK         SckRor;
    IPS_IPA         SckLocAdr;
    IPS_IPA         SckRemAdr;
    IPS_SCK         SckTrp;
    IPS_IPA         SckTrpAdr;
    char            SckCom [AGT_SZECOM];
    unsigned        SckComLen;
    unsigned        SckOji [AGT_SZEOJI];
    unsigned        SckOjiLen;
    long unsigned   SckIpa;
    int             SckEnaTrp;
    int             SckEnaAut;
    pkt_msg         SckMsg;
    char            SckPkt [AGT_SZEPKT];
}
    agt_sck;


extern agt_sck
    AgtSck;

int AgtIni __( ( short       Prt, unsigned    *Oji, unsigned    OjiLen, int         TrpEna, short       TrpPrt, char        *TrpHst, char        *TrpCom, unsigned    TrpComLen ) );
int AgtOpn __( ( void ) );
int AgtCls __( ( void ) );
int AgtSndTrp __( ( unsigned    Gen, unsigned    Spe, pkt_obj     *Lst, unsigned    LstLen ) );
int AgtRcvRqs __( ( char        *Com, unsigned    *ComLen, pkt_ror     *Rqs ) );
int AgtSndRsp __( ( char        *Com, unsigned    ComLen, pkt_ror     *Rsp ) );

#define MGT_SZECOM  255
#define MGT_SZEPKT  1024

typedef struct
{
    IPS_SCK         SckBsd;
    long unsigned   SckAdr;
    unsigned        SckRid;
}
    mgt_sck;


mgt_sck *MgtOpn __( ( int    Prt, long    Adr ) );
int MgtRqs __( ( mgt_sck         *Sck, pkt_msg         *Msg, long unsigned   Tio, unsigned        Rtr ) );
int MgtCls __( ( mgt_sck *Sck ) );
unsigned long MgtAdr __( ( char    *Hst ) );

#define TRP_SZEPKT  1024

typedef struct
{
    int             SckOpn;
    IPS_SCK         SckBsd;
    pkt_msg         SckMsg;
    char            SckPkt [TRP_SZEPKT];
}
    trp_sck;

extern trp_sck
    TrpSck;


int TrpOpn __( ( short       Prt ) );
int TrpPol __( ( pkt_trp     *Trp ) );
int TrpCls __( ( void ) );
int StrEncOid __( ( char        *Str, unsigned    *Oid, unsigned    OidLen ) );
int StrDecOid __( ( char        *Str, unsigned    *Oid, unsigned    *OidLen ) );
int StrEncOji __( ( char        *Str, pkt_obj     *Obj ) );
int StrDecOji __( ( char        *Str, pkt_obj     *Obj ) );
char *StrEncTag __( ( int     Tag ) );
int StrDecTag __( ( char    *Str ) );
int StrEncSyn __( ( char        *Str, pkt_obj     *Obj ) );
int StrDecSyn __( ( char        *Str, pkt_obj     *Obj ) );
int StrEncObj __( ( char        *Str, pkt_obj     *Obj ) );
int StrDecObj __( ( char        *Str, pkt_obj     *Obj ) );
char *StrEncErr __( ( int     Err ) );
char *StrEncTrp __( ( int     Trp ) );


#endif
