;
; Walk an SNMP table through a Beholder connection
;
; each time a entry is retrieved, <fnct> is called  with as argument
; the entry
(define (walk-table con tbl fnct)
  ()
  (define (table-loop connection table-index entry )
    (set! entry (car 
		 (snmp-getnext 
		   connection 
		   "public" 
		   5000000 
		   10 
		   (list entry))))
    (if entry
	(if (string=? 
	     table-index 
	     (substring (car entry) 0 (string-length table-index)))
	    (begin
	     (fnct entry)
	     (table-loop connection table-index entry)
	    )
	    ())
      ()))
  (table-loop con tbl (list tbl 0 0)))

;
; decode an entry using a table definition
;
;   (decode-table (<table-id> <len1> <len2> ...) (<var-id> type value))
;
(define (decode-table table-def entry)
  ()
  (define tab (dotted->list (car table-def)))
  (define ent (dotted->list (car entry)))
  (define lens (cdr table-def))
  (if (not (equal? tab (list-to ent (length tab))))
      ()
    (
     begin
     (set! ent (list-from ent (length tab)))
     (define (get-index lenl idxl)
       (if (not (and lenl idxl))
	   ()
	 (
	  begin
	  (cons (list-to idxl (car lenl))
		(get-index (cdr lenl) (list-from idxl (car lenl)))))))
     (list (get-index lens ent) (cadr entry) (caddr entry)))))
  
;
; Get a table 
;
(define (get-table con tbl fnct)
  ()
  (define table (walk-table con (car tbl)))
  (define (get-next lst)
    (if lst
	(cons (decode-table tbl (car lst)) 
	      (get-next (cdr lst)))
      ()))
  (get-next table))
