;Sage utility functions
;
;
; dotted list convertor
(define (dotted->list dotted)
  ()
  (define (list->number lst)
    (string->number (list->string (reverse lst))))
  (define (looper lst new)
    (if lst
        (if (eqv? (car lst) #\.)
            (cons (list->number new)
                  (looper (cdr lst) ()))
            (looper (cdr lst) (cons (car lst) new)))
        (if new
	    (list (list->number new)))))
  (looper (string->list dotted) ()))
 
(define (list->dotted lst)
  (define (add-nxt lst)
    (if lst (string-append (string-append (number->string (car lst)) ".")
			   (add-nxt (cdr lst)))
      ""))
  (add-nxt lst))
