/* 1635, Mon 21 Feb 94

   FD_PARSE.C:  Scanner/parser for fd_filter and fd_extract

   Copyright (C) 1992-1994 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>

#include <string.h>
#include <malloc.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>

#include "fd_data.h"

char *gnbr(unsigned int *n,char *s)  /* Get nbr from 's', */
{
   unsigned int v = 0, b = 10, d;
   while (*s == ' ') ++s;
   if (*s == 'x' || *s == 'X') {
      ++s;  b = 16;
      }
   else if (*s == '0') {
      ++s;  b = 8;
      }
   for (;;) {
      d = *s;
      if (b == 16) {
         if (!isxdigit(d)) break;
         }
      else {
         if (!isdigit(d)) break;
         if (b == 8 && d > '7') break;
         }
      if (d <= '9') d -= '0';
      else if (d <= 'F') d -= ('A'-10);
      else d -= ('a'-10);
      v = v*b + d;  ++s;
      }
   *n = v;  return s;
   }

char *gcstring(char *s, int *len)  /* Get string from s */
{
   static char escin[] = {
      'b', 'f', 'n', 'r', 't', 'v','\\','\'','\"','\?', 0 };
   static char escout[] ={
      '\b','\f','\n','\r','\t','\v','\\','\'','\"','\?' };
   unsigned int c,j;
   char sbuf[80], *t = sbuf, *rp;
   while (*s) {
      if (*s == '\\') {
         ++s;  c = *s;
         if (c == '0' || c == 'x' || c == 'X') {  /* Octal or hex nbr */
            s = gnbr(&c,s);  *t++ = c;
	    }
         else if isdigit(c) {  /* Octal number */
            --s;  *s = '0';  /* Make gnbr use base 8 */
            s = gnbr(&c,s);  *t++ = c;
	    }
         else {
            j = 0;  do {
               if (c == escin[j]) break;
	       } while (escin[++j] != 0);
            if (escin[j] != 0) {
               *t++ = escout[j];  ++s;
	       }
	    }
         }
      else *t++ = *s++;
      }
   *t = '\0';
   rp = malloc(*len = t-sbuf);  strcpy(rp,sbuf);
   return rp;
   }

int parse_open(char *fn)  /* Open file and initialise parser */
{
   if ((rfp = fopen(fn, "r")) == NULL) return 0;
   rferrors = rule_line = 0;  ic = '\n';
   return 1;
   }

void p_error(char *msg)
{
   if (!iblisted) {
      fprintf(stderr,"line %d: %s\n", rule_line,inbuf);
      iblisted = 1;
      }
   fprintf(stderr,"%s !!!\n", msg);
   ++rferrors;
   }

int nextchar(void)
{
   char *p;
   lic = ic;
   for (;;) {
      if (lic == '\n') {
	 if (fgets(inbuf, sizeof(inbuf), rfp) == NULL) return ic = EOF;
         for (p = inbuf; *p; *p++ = tolower(*p)) ;
	 iblisted = 0;  ++rule_line;
	 ibp = inbuf;
	 }
      ic = *ibp++;
      if (ic == '#') lic = '\n';  /* Ignore comments */
      else return ic;
      }
   }

int nexttoken(void)
{
   for (;;) {
      if (isalnum(ic) || ic == '_') return 1;
      if (ic == ';' || ic == EOF) return 0;
      nextchar();
      }
   }

void getfdstring(char *arg)
{
   for (;;) {
      if (isxdigit(ic)) break;  /* Addresses start with a (hex) digit */
      nextchar();
      }
   if (ic != EOF) do {
      *arg++ = toupper(ic);
      nextchar();  /* Addresses may include . (decimal) or - (hex) */
      } while (isxdigit(ic) || ic == '.' || ic == '-');
   *arg = '\0';  return;

   }

int wordis(char *p, char *w)
{
   if (strlen(p) != strlen(w)) return 0;  /* Lengths differ */
   return strcmp(p,w) == 0;
   }

int getword(void)
{
   char wbuf[50], *wp = wbuf;
   int j;
   for (;;) {
      *wp++ = ic;
      nextchar();
      if (ic == EOF) return EOF;
      if (!isalnum(ic) && ic != '_') break;
      }
   *wp = '\0';

   if (wordis(wbuf,"set")) return RF_SET;
   if (wordis(wbuf,"format")) return RF_FORMAT;
   if (wordis(wbuf,"tag")) return RF_TAG;
   if (wordis(wbuf,"statistics")) return RF_STATS;
   if (wordis(wbuf,"column")) return RF_COLUMN;
   if (wordis(wbuf,"time")) return RF_TIME;

   if (wordis(wbuf,"scale")) return EX_SCALE;
   if (wordis(wbuf,"kilo")) return EX_KILO;
   if (wordis(wbuf,"mega")) return EX_MEGA;
   if (wordis(wbuf,"elapsed")) return EX_ELAPSED;
   if (wordis(wbuf,"clock")) return EX_CLOCK;
   if (wordis(wbuf,"seconds")) return EX_SECS;
   if (wordis(wbuf,"minutes")) return EX_MINS;
   if (wordis(wbuf,"hours")) return EX_HOURS;
   if (wordis(wbuf,"days")) return EX_DAYS;

   if (wordis(wbuf,"ip")) return AT_IP;
   if (wordis(wbuf,"clns")) return AT_CLNS;
   if (wordis(wbuf,"decnet")) return AT_DECNET;
   if (wordis(wbuf,"novell")) return AT_NOVELL;
   if (wordis(wbuf,"ethertalk")) return AT_ETHERTALK;
   if (wordis(wbuf,"other")) return AT_OTHER;

   if (wordis(wbuf,"icmp")) return PT_ICMP;
   if (wordis(wbuf,"tcp")) return PT_TCP;
   if (wordis(wbuf,"udp")) return PT_UDP;

   if (wordis(wbuf,"ftpdata")) return WNP_FTPDATA;
   if (wordis(wbuf,"ftp")) return WNP_FTP;
   if (wordis(wbuf,"telnet")) return WNP_TELNET;
   if (wordis(wbuf,"smtp")) return WNP_SMTP;
   if (wordis(wbuf,"domain")) return WNP_DOMAIN;
   if (wordis(wbuf,"nntp")) return WNP_NNTP;
   if (wordis(wbuf,"ntp")) return WNP_NTP;
   if (wordis(wbuf,"snmp")) return WNP_SNMP;

   for (j = 0; j != NATTRIBS+1; ++j) {
      if (wordis(wbuf,attribs[j].name)) return j;
      }
   sprintf(ebuf, "Unknown word %s", wbuf);
   p_error(ebuf);
   return 0;
   }

int getnbr(void)  /* Words return negative numbers */
{
   int v = 0;
   for (;;) {
      if (ic == EOF) return EOF;
      if (isdigit(ic)) break;
      if (isalpha(ic)) return getword();
      nextchar();
      }
   for (;;) {
      v = v*10 + ic-'0';
      if (nextchar() == EOF) return EOF;
      if (!isdigit(ic)) break;
      }
   return v;
   }

void scan_format(struct flow_stats *fs, int single_record, int list)
{
   char sbuf[32], *sp;
   int a, n, len;

   for (a = 0; a != NATTRIBS+1; ++a)
      fs->format[a] = fs->required[a] = 0;

   for (a = 0; ; ++a) {
      n = getnbr();     
      if (n < 0 || n > NATTRIBS) {
         sprintf(ebuf, "Attribute %d not allowed in format",n);
         p_error(ebuf);
         }
      else {
         fs->format[a] = n;  fs->required[n] = 1;
         }
      for (;;) {  /* Look for attribute or separator */
         if ((single_record && ic == '\n') || ic == ';' ||
            ic == '\"' || isalnum(ic)) break;
         nextchar();
         }
      if (ic == '\"') {  /* Separator string */
         nextchar();
         for (sp = sbuf; ; ) {
            if (ic == '\"') {
	       *sp = '\0';
	       fs->separator[a] = gcstring(sbuf, &len);
               for (;;) {
                  if ((single_record && ic == '\n') || ic == ';' ||
                     ic == '\"' || isalnum(ic)) break;
                  else nextchar();
                  }
	       break;
	       }
	    else *sp++ = ic;
	    nextchar();
            }
         }
      else fs->separator[a] = " ";
      if ((single_record && ic == '\n') || ic == ';') {
         if (list) {
	    fprintf(stderr,"Format: ");
            for (n = fs->format[a = 0]; ; ) {
               if (n != NULL) fprintf(stderr,attribs[n].name);
               if ((n = fs->format[a+1]) == NULL) break;
               fprintf(stderr,fs->separator[a++]);
               }
            fprintf(stderr,"\n");
            }
         return;
         }
      }
   }

val attrib_ptr(struct flow_info *fip, int a)
{
   val v;
   switch (a) {
   case FTFLOWINDEX:
      v.intval = &fip->FlowIndex;
      break;
   case FTLOWINTERFACE:
      v.intval = &fip->LowInterface;
      break;
   case FTLOWADJACENTTYPE:
      v.intval = &fip->LowAdjType;
      break;
   case FTLOWADJACENTADDRESS:
      v.charval = fip->LowAdjAddress;
      break;
   case FTLOWADJACENTMASK:
      v.charval = fip->LowAdjMask;
      break;
   case FTLOWPEERTYPE:
      v.intval = &fip->LowPeerType;
      break;
   case FTLOWPEERTYPEMASK:
      v.intval = &fip->LowPeerTypeMask;
      break;
   case FTLOWPEERADDRESS:
      v.charval = fip->LowPeerAddress;
      break;
   case FTLOWPEERMASK:
      v.charval = fip->LowPeerMask;
      break;
   case FTLOWDETAILTYPE:
      v.intval = &fip->LowDetailType;
      break;
   case FTLOWDETAILTYPEMASK:
      v.intval = &fip->LowDetailTypeMask;
      break;
   case FTLOWDETAILADDRESS:
      v.intval = &fip->LowDetailAddress;
      break;
   case FTLOWDETAILMASK:
      v.intval = &fip->LowDetailMask;
      break;
   case FTHIINTERFACE:
      v.intval = &fip->HighInterface;
      break;
   case FTHIADJACENTTYPE:
      v.intval = &fip->HighAdjType;
      break;
   case FTHIADJACENTADDRESS:
      v.charval = fip->HighAdjAddress;
      break;
   case FTHIADJACENTMASK:
      v.charval = fip->HighAdjMask;
      break;
   case FTHIPEERTYPE:
      v.intval = &fip->HighPeerType;
      break;
   case FTHIPEERTYPEMASK:
      v.intval = &fip->HighPeerTypeMask;
      break;
   case FTHIPEERADDRESS:
      v.charval = fip->HighPeerAddress;
      break;
   case FTHIPEERMASK:
      v.charval = fip->HighPeerMask;
      break;
   case FTHIDETAILTYPE:
      v.intval = &fip->HighDetailType;
      break;
   case FTHIDETAILTYPEMASK:
      v.intval = &fip->HighDetailTypeMask;
      break;
   case FTHIDETAILADDRESS:
      v.intval = &fip->HighDetailAddress;
      break;
   case FTHIDETAILMASK:
      v.intval = &fip->HighDetailMask;
      break;
   case FTRULESET:
      v.intval = &fip->FlowRuleSet;
      break;
   case FTFLOWTYPE:
      v.intval = &fip->FlowType;
      break;
   case FTUPOCTETS:
      v.intval = &fip->FwdBytes;
      break;
   case FTUPPDUS:
      v.intval = &fip->FwdPackets;
      break;
   case FTDOWNOCTETS:
      v.intval = &fip->BackBytes;
      break;
   case FTDOWNPDUS:
      v.intval = &fip->BackPackets;
      break;
   case FTFIRSTTIME:
      v.intval = &fip->FirstTime;
      break;
   case FTLASTTIME:
      v.intval = &fip->LastTime;
      break;
   case FTUPOCTETRATE:
      v.intval = &fip->upbci;
      break;
   case FTUPPDURATE:
      v.intval = &fip->uppci;
      break;
   case FTDOWNOCTETRATE:
      v.intval = &fip->dnbci;
      break;
   case FTDOWNPDURATE:
      v.intval = &fip->dnpci;
      break;
   case FTTAGNBR:
      v.intval = &fip->TagNbr;
      break;
   default:
      v.intval = NULL;
      break;
      }
   return v;
   }

/* get_value() and put_value() are simplified routines for working
   with flow data files.  Strings are delimited by blanks! */

char *get_value(val v, int a, char *pb)
{
   unsigned long val;
   int i;
   char *p;

   if (*pb == '\0') return NULL;
   while (isspace(*pb)) pb++;
   if (string_value(a)) {
      for (i = 0, p = v.charval; 
            *pb && *pb != ' ' && i < STR_LEN;  i++ )
         *p++ = *pb++;
      *p = '\0';
      }
   else {  /* Unsigned int */
      sscanf(pb, "%u", v.intval);
      while (isdigit(*pb)) pb++;
      }
   return pb;
   }

void put_value(FILE *out, int a, val v)
{
   if (string_value(a)) {
      fprintf(out,"%s",v.charval);
      }
   else {
      fprintf(out,"%u",*v.intval);
      }
   }
