/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The driver for the server/responder procedures
 */

#include <general.h>

exec_server(server, be, stat)
    struct server_t *server;
    struct bench *be;
    statistics_t *stat;
{
    iohdl_t *srchdl, *dsthdl;    
    struct datasp *dt;
    int bufsize, ret, iterations, itemsize;
    metrics_t mts, *mt = &mts;
    
    tprintf("exec_server(0x%x, 0x%x, 0x%x)\n", server, be, stat);
    
    /* Check parameters */

    if (bench_symbol(be) == NULLSE) {
	eprintf(EF_IN4, INTERNAL, PARAMETER,  "exec_server",
		"bench_symbol is NULLSE");
	return NOTOK;
    }

    if (!bench_isbasic(be)) {
	eprintf(EF_IN3, INTERNAL, "not a basic benchmarks", "exec_server");
	return NOTOK;
    }

    if (basic_data(be) == NULLDT) {
	eprintf(EF_IN4, INTERNAL, PARAMETER, "exec_server",
		"data specification is NULL");
	return NOTOK;
    }
    dt = basic_data(be);
    
    if (datasp_iterations(dt) == SS_DEFAULT) {
	   datasp_iterations(dt) = MAX_ITERATIONS;
    }
    iterations = datasp_iterations(dt);

    if (Debug) {
      datasp_print(dt);
    }

    /* Setup the source and destination */

    srchdl = access2iohdl(datasp_src(dt));
    dsthdl = access2iohdl(datasp_dst(dt));

    if (Debug) {
      printf("dsthdl: ");
      io_print(dsthdl);
      printf("srchdl: ");
      io_print(srchdl);
    }
      
    itemsize = type2size(datasp_type(dt));
    bufsize = itemsize * datasp_maxsendsize(dt);

    /* GROSS HACK for virtual memory things */
    if (iohdl_isvm(srchdl)) 
	ret = (*srchdl->io_open)(srchdl, source, bufsize*iterations);
    else	
	ret = (*srchdl->io_open)(srchdl, source, bufsize);

    if (ret == NOTOK) {
	eprintf(EF_IN3, INTERNAL, "Failed opening the source",
		"exec_server");
	return NOTOK;
    }	

    bufsize = itemsize * datasp_maxrecvsize(dt);

    if (iohdl_isvm(dsthdl)) 
 	ret = (*dsthdl->io_open)(dsthdl, destination, bufsize*iterations);
    else       
	ret = (*dsthdl->io_open)(dsthdl, destination, bufsize);

    if (ret == NOTOK) {
	eprintf(EF_IN3, INTERNAL, "Failed opening the destination",
		"exec_server");
	return NOTOK;
    }
						
    iohdl_setitemsize(srchdl, itemsize);
    iohdl_setitemsize(dsthdl, itemsize);

    
    ret = (*bench_server_proc(be))(be, server, srchdl, dsthdl, &mt);
    (*srchdl->io_destroy)(srchdl);
    (*dsthdl->io_destroy)(dsthdl);
    srchdl = NULLIO;
    dsthdl = NULLIO;
    
    if (ret == NOTOK) {
	eprintf(EF_IN3, INTERNAL, "*bench_server_proc", "exec_server");
    } else {
        Metrics2Stats(&mt, stat);
    }
 	
    return ret;
} /* exec_server */    
