/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * xmalloc() and xfree() routines - storage allocation with debugging
 */

#include <general.h>

#ifdef malloc
#undef malloc
#undef free

static int Trace = 0;
static int TotTrace = 0;

static int indexnum = 0;
static int nalloc = 0;
static int totsize = 0;

struct header {
    struct header *myself;	/* for checking */
    unsigned size;		/* excluding the header */
    int indexnum;		/* for pairing malloc and free */
};
    
#ifdef XMALLOC_FILE
char *xmalloc(n, file, line)
    unsigned n;
    char *file;
    int line;
{
#else    
char *xmalloc(n)
    unsigned n;
{
    char *file = "Unknown file";
    int line = 0;
#endif
    unsigned size = n + sizeof(struct header);
    struct header *block;
    char *ptr;

    return (char *) malloc(n);
    block = (struct header *)malloc(size);
    if (block == NULL) {
	tprintf("xmalloc(%u) returns NULL\n", n);
	return NULL;
    }
    block->myself = block;
    block->size = n;
    block->indexnum = indexnum++;
    ptr = (char *)(block + 1);
    nalloc++;
    totsize += n;

    if (TotTrace) {
	printmyname(),
	printf("xmalloc (%u, %s, %d) -> 0x%x, index %d, nalloc %d, totsize %d\n",
	       n, file, line,
	       ptr, block->indexnum, nalloc, totsize);
    } else {
	tprintf("xmalloc (%u, %s, %d) -> 0x%x\n", n, file, line, ptr);
    }
    return ptr;
} /* xmalloc */

#ifdef XMALLOC_FILE
xfree(ptr, file, line)
    char *ptr;
    char *file;
    int line;
{
#else
xfree(ptr)
    char *ptr;
{
    char *file = "Unknown file";
    int line = 0;
#endif
    struct header *block;

    return free(ptr);
    if (ptr == NULL) {
	eprintf("xfree(NULL, %s, %d)\n", file, line);
	return;
    }
    block = (struct header *)(ptr - sizeof(struct header));

    if (block->myself != block) {
	if (block->myself == (struct header *)(-1) && block->size == 0) {
	    eprintf("xfree(0x%x, %s, %d): probably already freed\n",
		    ptr, file, line);
	} else {
	    eprintf("xfree(0x%x, %s, %d): block 0x%x, myself 0x%x called from 0x%x\n",
		ptr, file, line, block, block->myself, ((long *)&ptr)[-1] );
	}
	return;
    }

    nalloc--;
    totsize -= block->size;

    if (TotTrace) {
	printmyname(),
	printf("xfree (0x%x, %s, %d): size %u, index %d, nalloc %d, totsize %d\n",
	       ptr, file, line, block->size, block->indexnum, nalloc, totsize);
    } else {
	tprintf("xfree (0x%x, %s, %d): size %u\n", 
		ptr, file, line, block->size);
    }
    
    block->myself = (struct header *)(-1);
    block->size = 0;

    free((char *)block);
	
    return;
} /* xfree */

#endif malloc

