/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Subroutines used by demon_server()
 */

#include <general.h>
#include <ipc.h>
#include <ipc_pres.h>

/*  */

int handle_timeout(a_state, rq, rp)
    state_t *a_state;
    msg_t *rq, *rp;
{
    state_t state = *a_state;
    
    tprintf("handle_timeout(0x%x, 0x%x, 0x%x)\n", a_state, rq, rp);

    switch (state) {
    case UNKNOWN:
    case INIT:
	eprintf("Timed out in bad state %s\n", state2str(state));
	return NOTOK;

    case CREATING:
    case SETUP:
    case WAIT_INIT:
    case FAILING:
	eprintf("Timed out in state %s - aborting\n", state2str(state));
	rp->msg_code = MSG_ABORT;
	*a_state = ABORTING;
	rp->msg_to.ba_addr = BA_BENCH;
	return DONE;	/* send rp */

    case IDLE:
    case WAIT_STARTED:
    case EXECUTING:
    case WAIT_STOPPED:
    case WAIT_TERM:
    case TAREDOWN:
    case RESETTING:
    case ABORTING:
	dprintf("Timed out in state %s - continuing\n",
		state2str(state));
	return OK;
    }
} /* handle_timeout */

/*  */
	

