/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Alarm handling - alarms are used when there is a time limit on
 * the benchmark. The expiration of the alarm should cause a SIGALRM
 * signal that will be handled by hdl_alarm() (It will be translated to
 * a MSG_ALARM sent to the process which got the signal!)
 */

#include <general.h>

/*
 * Exports:
 */
void bench_alarm();
void bench_unalarm();

/*  */

void bench_alarm(time)
    double time;
{
    int secs;

    tprintf("bench_alarm(%.2f)\n", time);

    secs = time;
    (void)alarm(secs);
} /* bench_alarm */

/*  */

void bench_unalarm()
{
    int secs;

    tprintf("bench_unalarm()\n");

    secs = alarm(0);

    dprintf("bench_unalarm: %d secs remaining\n", secs);
	    
} /* bench_unalarm */
