/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Responder template measurement procedure
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>

int templated(be, server, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct server_t 	*server;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    RESPONDER_VARIABLES;
    TIMING_VARIABLES(1);	/* One or more timing varaibles. The number is
				   the number in the timing list in
				   the measurement specification */
    channel_t ch;
    

    mprintf("templated(be 0x%x, src 0x%x, dst 0x%x, mt 0x%x)\n",
		 be, srchdl, dsthdl, mt);


    TIMING_INITIATE(1);		/* For each timing variable */


    RESPONDER_BEFORE_START;

    StartMeasurements(mt);
    

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;

	/* Use these to find out the data unit size */
	RESPONDER_RECVSIZE(msgsize,i);
	RESPONDER_SENDSIZE(msgsize,i);

	/* Insert these where you want delays */
	TIMING_DELAY(1);
    }

    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;
    
    return OK;

abort:
    return NOTOK;    

} /* templated */

