/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring two-way delay including session/connection
 * setup and taredown. DEMON
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>


int queryd(be, server, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct server_t 	*server;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    RESPONDER_VARIABLES;
    TIMING_VARIABLES(1);
    TIMING_VARIABLES(2);
    channel_t ch;
    
    mprintf("queryd(be 0x%x, src 0x%x, dst 0x%x, mt 0x%x)\n",
		 be, srchdl, dsthdl, mt);

    TIMING_INITIATE(1);
    TIMING_INITIATE(2);

    RESPONDER_BEFORE_START;

    StartMeasurements(mt);
    
    for (i = 0; i < iterations; i++) {
	RESPONDER_RECVSIZE(msgsize,i);
	QueryAwaitCallInd(server, srchdl->io_buffer, msgsize, &ch, &error);
	if (failed(&error)) {
	    report_error(&error, "QueryAwaitCallInd");
	    return NOTOK;
	}

	TIMING_DELAY(1);

	RESPONDER_SENDSIZE(msgsize, i);
	QueryReturn(ch, dsthdl->io_buffer, msgsize, &error);
	if (failed(&error)) {
	    report_error(&error, "QueryReturn");
	    return NOTOK;
	}

	if (interupted)
	    break;

	TIMING_DELAY(2);
    }

    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;
    
    return OK;
} /* queryd */


