/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring one-way bulk data transfer DEMON
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>



int nodelayd(be, server, srchdl, dsthdl, mt)
    struct bench	*be;
    struct server_t 	*server;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    RESPONDER_VARIABLES;
    TIMING_VARIABLES(1);
    channel_t ch;
    

    mprintf("nodelayd(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    TIMING_INITIATE(1);

    RESPONDER_BEFORE_START;

    StartMeasurements(mt);
    
    AwaitConnInd(server, &ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitConnInd");
	return NOTOK;
    }

    if (interupted)
	    return OK;

    AwaitBulkGetStart(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitBulkGetStart");
	goto abort;
    }
    
    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	RESPONDER_SENDSIZE(msgsize,i);
	BulkGetDataReq(ch, srchdl->io_buffer, msgsize, &error);
	if (failed(&error)) {
	    report_error(&error, "BulkGetDataReq");
	    goto abort;
	}
	if (interupted)
	    break;
#define bench_delay(time) mprintf("NOT delaying!\n");	
	TIMING_DELAY(1);
#undef bench_delay	
    }

    if (interupted)
	return OK;
    AwaitBulkGetStop(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitBulkGetStop");
	goto abort;
    }

    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;
    
    if (interupted)
	return OK;
    AwaitDiscInd(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitDiscInd");
	return NOTOK;
    }
    return OK;

abort:
    AwaitDiscInd(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitDiscInd on abort");
    }
    return NOTOK;
    
} /* nodelayd */
