/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for benchmarks on the TCP level 
 */

#ifndef _TCP_
#define _TCP_

#ifndef __SOCKET__
#define __SOCKET__
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif __SOCKET__

/* A channel is a socket number */
typedef int channel_t;
struct server_t {
    int sock;		/* a socket being listened on */
};


#include "../protoaddrs/portaddr.h"

/*
 * Error handling
 */

typedef int error_t;
#define failed(errind)	(*errind == NOTOK)

#define report_error(errind,str)	tcp_report_error(errind,str)


#define InitClient()		{};

#define ConnRequest(addr,a_ch,errind) \
{   pprintf("ConnRequest(0x%x, 0x%x, 0x%x)\n", addr, a_ch, errind); \
    if ((*a_ch = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == NOTOK) { \
	eprintf(EF_SYSCALL,  COMMUNICATION, "socket call", "tcp_conn_request",\
	       getsyserr());\
	*errind = NOTOK;\
    } else if (connect(*a_ch, addr, sizeof(*addr)) == NOTOK) {\
	eprintf(EF_SYSCALL, COMMUNICATION, "connect call", "tcp_conn_request",\
	       getsyserr());\
	*errind = NOTOK;\
    } else {\
        *errind = OK;\
    }\
 }

#define CreateChannel(addr,a_ch,errind) \
{    if ((*a_ch = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == NOTOK) { \
	eprintf(EF_SYSCALL,  COMMUNICATION, "socket call", "tcp_create_channel",\
	       getsyserr());\
	*errind = NOTOK;\
    } else {\
	*errind = OK;\
    }\
 }

#define DiscRequest(ch, errind) \
{    pprintf("DiscRequest(%d, 0x%x)\n", ch, errind); \
     if (close(ch)== NOTOK) { \
	eprintf(EF_SYSCALL, COMMUNICATION, "close call", "tcp_disc_request", \
	       getsyserr());\
  	*errind = NOTOK;\
    } else {\
	*errind = OK;\
    }\
 }

#define DestroyChannel(ch, errind)	DiscRequest(ch, errind)

#define AwaitConnInd(serverp, a_ch, errind) \
{\
    struct sockaddr_in otheraddr;\
    int len = sizeof(otheraddr);\
    pprintf("AwaitConnInd(%d, 0x%x, 0x%x)\n", serverp->sock, a_ch, errind); \
    if ((*a_ch = accept(serverp->sock, &otheraddr, &len)) == NOTOK) {\
	eprintf(EF_SYSCALL, COMMUNICATION, "accept call", "tcp_await_conn_ind",\
	       getsyserr());\
	*errind = NOTOK;\
    } else {\
    	*errind = OK;\
    }\
}


#define AwaitDiscInd(ch, errind) \
{\
    char buf;	/* very small buffer */\
    int cc;	/* Not char to work with int constant EOF */\
    pprintf("AwaitDiscInd(%d, 0x%x)\n", ch, errind); \
    cc = read(ch, &buf, 1);\
    if (cc == NOTOK) {\
 	int tmp = errno;\
	eprintf(EF_SYSCALL, COMMUNICATION, "read on a tcp socket",\
		    "tcp_await_disc_ind", getsyserr());\
	(void)close(ch);\
	errno = tmp;\
	*errind = NOTOK;\
    } else {\
	if (cc != 0) {\
	    eprintf(EF_SYSCALL, COMMUNICATION, "receiving data",\
		    "tcp_await_disc_ind",\
			"\nShould get a 0 i.e. EOF = DiscIndication");\
	}\
    }\
    if (close(ch)== NOTOK) {\
	eprintf(EF_SYSCALL, COMMUNICATION, "close call", "tcp_await_disc_ind",\
		    getsyserr());\
    }\
    *errind = OK;\
}

#define CreateServer(aa_server, aa_addr, errind) \
  				tcp_create_server(aa_server, aa_addr, errind)
#define DestroyServer(a_server, errind) \
    				tcp_destroy_server(a_server, errind)

#define DataRequest(channel,buffer,amount, errind) \
{ pprintf("DataRequest(%d, 0x%x, %d, 0x%X\n", channel, buffer, amount, errind);\
  if (write(channel, buffer, amount) == NOTOK) \
      *errind = NOTOK; \
  else \
      *errind = OK;					\
}

/* problem when length bytes aren't read! */
#define AwaitDataIndication(channel, buffer, amount, errind)	\
{ 				\
      int left = amount;	 		\
      int got;				\
  				\
      pprintf("AwaitDataIndication(%d, 0x%x, %d, 0x%X\n", \
	      channel, buffer, amount, errind);\
	*errind = OK;			\
      while (left > 0 && !interupted) {			\
	  got = read(channel, buffer, left);		\
	  if (got < 0) { /* error */		\
	      *errind = NOTOK;			\
	      break;			\
	  } 				\
	  if (got == 0) { /* end-of-file */		\
	      errno = 0; 			\
	      *errind = NOTOK;			\
	      break;			\
	  }				\
	  left -= got;			\
      }				\
}

#define BulkGetDataReq		DataRequest
#define BulkPutDataReq  	DataRequest
#define BulkGetAwaitDataInd	AwaitDataIndication
#define BulkPutAwaitDataInd	AwaitDataIndication

#define RRSendRequest 		BulkPutDataReq
#define RRAwaitResponseInd	BulkGetAwaitDataInd
#define RRAwaitRequestInd	BulkPutAwaitDataInd
#define RRSendResponse		BulkGetDataReq

/*
 * Synchronize with the sender to avoid buffering anomalies (the
 * sender starting before this receiver and the receiver just retrieves
 * data from the buffers!)
 */

#define BulkGetStart(ch, errind) \
{	\
    char buffer;	/* small buffer */	\
    DataRequest(ch, &buffer, 1, errind);	\
}

#define AwaitBulkGetStart(ch, errind)	\
{	\
    char buffer;	/* small buffer */	\
    AwaitDataIndication(ch, &buffer, 1, errind);	\
}

#define BulkGetStop(ch, errind) 	\
	    			{*errind = OK; }

#define AwaitBulkGetStop(ch, errind)	\
	    			{*errind = OK; }



#define BulkPutStart(ch, errind)	\
	    			{*errind = OK; }

#define AwaitBulkPutStart(ch, errind)\
	    			{*errind = OK; }

#define BulkPutStop(ch, errind)	\
{	\
    char buffer;	/* small buffer */	\
    AwaitDataIndication(ch, &buffer, 1, errind);	\
}

#define AwaitBulkPutStop(ch, errind)	\
{	\
    char buffer;	/* small buffer */	\
    DataRequest(ch, &buffer, 1, errind);	\
}


#define QueryCall(addrp, srcbuf, srclen, dstbuf, dstlen, errind) \
{ \
  channel_t ch; \
 \
  ConnRequest(addrp, &ch, errind); \
  if (!failed(errind)) { \
    RPCCall(ch, srcbuf, srclen, dstbuf, dstlen, errind); \
    if (!failed(errind)) { \
      DiscRequest(ch, errind); \
    } \
  } \
}

#define QueryAwaitCallInd(serverp, dstbuf, dstlen, chp, errind) \
{ \
    AwaitConnInd(serverp, chp, errind); \
	if (!failed(errind)) { \
	RPCAwaitCallInd(*(chp), dstbuf, dstlen, errind); \
    } \
}

#define QueryReturn(ch, srcbuf, srclen, errind) \
{ \
    RPCReturn(ch, srcbuf, srclen, errind); \
    if (!failed(errind)) { \
	AwaitDiscInd(ch, errind); \
    } \
}

#define RPCCall(ch, srcbuf, srclen, dstbuf, dstlen, errind) \
{ \
      DataRequest(ch, srcbuf, srclen, errind); \
      if (!failed(errind)) { \
	     AwaitDataIndication(ch, dstbuf, dstlen, errind); \
	     if (failed(errind)) { \
		report_error(errind, "AwaitDataIndication in RPCCall"); \
		return NOTOK; \
	     } \
      } \
}

#define RPCAwaitCallInd(ch, dstbuf, dstlen, errind) \
{ \
    AwaitDataIndication(ch, dstbuf, dstlen, errind); \
}

#define RPCReturn(ch, srcbuf, srclen, errind) \
{ \
    DataRequest(ch, srcbuf, srclen, errind); \
}
		
#endif _TCP_
