/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * FTAM protocol specific code
 * Bulk operations
 */

/*
 * TODO
 */


#include <general.h>
#include <protospec.h>



extern struct vfsmap vfs[];

#define INF_WAIT NOTOK

void ftam_diag(), ftam_chrg();

/*  */

ftam_start_bulk_get(ch, errind)
    channel_t ch;
    error_t *errind;
{
    struct FTAMgroup ftgs, *ftg = &ftgs;
    struct FADUidentity faduids;
    struct FADUidentity   *faduid = &faduids;
    
    pprintf("ftam_start_bulk_get(%d, 0x%x)\n", ch, errind);

    bzero ((char *) ftg, sizeof *ftg);
    ftg->ftg_flags |= FTG_BEGIN | FTG_END;
    ftg->ftg_threshold = 0;

    ftg->ftg_flags |= FTG_SELECT;
    {
	register struct FTAMselect *ftse = &ftg->ftg_select;
	register struct FTAMattributes *fa = &ftse->ftse_attrs;

	fa->fa_present = FA_FILENAME;
	fa->fa_nfile = 0;
#ifdef notdef
	fa->fa_files[fa->fa_nfile++] = src;
#endif notdef
	ftse->ftse_access = FA_PERM_READ;
	FCINIT (&ftse->ftse_conctl);
    }
    ftg->ftg_threshold++;

    ftg->ftg_flags |= FTG_OPEN;
    {
	register struct FTAMopen *ftop = &ftg->ftg_open;

	ftop->ftop_mode = FA_PERM_READ;
	ftop->ftop_contents = vfs[VF_INDEX].vf_oid;
	FCINIT (&ftop->ftop_conctl);
	ftop->ftop_conctl.fc_readlock = FLOCK_SHARED;
    }
    ftg->ftg_threshold++;

    errind->er_ret = FBulkBeginRequest (ch, ftg, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FBulkBeginRequest", 
	       "ftam_start_bulk_get");
	errind->er_tag = ERT_FTI;
	return;
    }

    ftg = &errind->er_fti. fti_group;

    if (ftg->ftg_flags & FTG_SELECT) {
	register struct FTAMselect *ftse = &ftg->ftg_select;

	ftam_diag (ftse->ftse_diags, ftse->ftse_ndiag, 1,
		ftse->ftse_action);
	if (ftse->ftse_state != FSTATE_SUCCESS) {
	    eprintf(EF_IN4X, COMMUNICATION, "FBulkBeginRequest",
		   "ftam_start_bulk_get", "FTAMselect has non-FSTATE_SUCCESS");
 	    errind->er_ret = NOTOK;
	    errind->er_tag = ERT_NONE;
	    FTGFREE (ftg);
	    return;
	}
    }

    if (ftg->ftg_flags & FTG_OPEN) {
	register struct FTAMopen *ftop = &ftg->ftg_open;

	ftam_diag (ftop->ftop_diags, ftop->ftop_ndiag, 1,
		ftop->ftop_action);
	if (ftop->ftop_state != FSTATE_SUCCESS) {
	    eprintf(EF_IN4X, COMMUNICATION, "FBulkBeginRequest",
		   "ftam_start_bulk_get", "FTAMopen has non-FSTATE_SUCCESS");
 	    errind->er_ret = NOTOK;
	    errind->er_tag = ERT_NONE;
	    FTGFREE (ftg);
	    return;
	}
    }

    FTGFREE (ftg);

    faduid->fa_type = FA_FIRSTLAST;
    faduid->fa_firstlast = FA_FIRST;

    errind->er_ret = FReadWriteRequest (ch, FA_OPS_READ, faduid,
					vfs[VF_INDEX].vf_context, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FReadWriteRequest",
	       "ftam_start_bulk_get");
	errind->er_tag = ERT_FTI;
	return;
    }

} /* ftam_start_bulk_get */

/*  */

ftam_stop_bulk_get(ch, errind)
    channel_t ch;
    error_t *errind;
{
    struct FTAMgroup ftgs, *ftg = &ftgs;

    pprintf("ftam_stop_bulk_get(%d, 0x%x)\n", ch, errind);


    errind->er_ret = ftam_wait_request(ch, FTI_DATAEND, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_stop_bulk_get");
	return;
    }
    /* FTI_DATAEND */
    {
	struct FTAMdataend *ftda = &errind->er_fti.fti_dataend;

	/* Do nothing */
    }

    errind->er_ret = FTransEndRequest (ch, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FTransEndRequest",
	       "ftam_stop_bulk_get");
	errind->er_tag = ERT_FTI;
	return;
    }

    switch (errind->er_fti. fti_type) {
	case FTI_TRANSEND:
	    {
		register struct FTAMtransend *ftre = &errind->er_fti. fti_transend;

		ftam_diag (ftre->ftre_diags, ftre->ftre_ndiag, 1,
			ftre->ftre_action);
	    }
	    break;

	case FTI_CANCEL:
	    {
		register struct FTAMcancel *ftcn = &errind->er_fti. fti_cancel;
		
		pprintf(EF_IN4X, COMMUNICATION, "FTransEndRequest",
		       "ftam_stop_bulk_get", "data transfer canceled!");
		ftam_diag (ftcn->ftcn_diags, ftcn->ftcn_ndiag, 1, 
			ftcn->ftcn_action);

		errind->er_ret = FCancelResponse (ch, FACTION_SUCCESS,
			    (struct FTAMdiagnostic *) 0, 0, &errind->er_fti);
		if (errind->er_ret == NOTOK) {
		    errind->er_tag = ERT_FTI;
		    pprintf(EF_IN3, COMMUNICATION, "FCancelResponse",
			   "ftam_stop_bulk_get");
		}
	    }
	    break;

	default: {
 	    eprintf(EF_IN4X, COMMUNICATION, "FTransEndRequest",
		   "ftam_stop_bulk_get",
		   "unexpected indication type");
	    errind->er_ret = NOTOK;
	    errind->er_tag = ERT_NONE;
	    return;
	}
    }

done_transfer: ;
    ftg = &ftgs;
    bzero ((char *) ftg, sizeof *ftg);
    ftg->ftg_flags |= FTG_BEGIN | FTG_END;
    ftg->ftg_threshold = 0;

    ftg->ftg_flags |= FTG_CLOSE;
    ftg->ftg_threshold++;

    ftg->ftg_flags |= FTG_DESELECT;
    ftg->ftg_threshold++;

    errind->er_ret = FBulkEndRequest (ch, ftg, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FBulkEndRequest", "ftam_stop_bulk_get");
	errind->er_tag = ERT_FTI;
	return;
    }

    ftg = &errind->er_fti. fti_group;

    if (ftg->ftg_flags & FTG_CLOSE) {
	register struct FTAMclose     *ftcl = &ftg->ftg_close;

	ftam_diag (ftcl->ftcl_diags, ftcl->ftcl_ndiag, 1,
		ftcl->ftcl_action);
    }

    if (ftg->ftg_flags & FTG_DESELECT) {
	register struct FTAMdeselect   *ftde = &ftg->ftg_deselect;

	ftam_diag (ftde->ftde_diags, ftde->ftde_ndiag, 1,
		ftde->ftde_action);
	ftam_chrg (&ftde->ftde_charges);
    }

    FTGFREE (ftg);
    errind->er_ret = OK;
    
} /* ftam_stop_bulk_get */

/*  */

ftam_await_start_bulk_get(ch, errind)
    channel_t ch;
    error_t *errind;
{

    pprintf("ftam_await_start_bulk_get(%d, 0x%x)\n", ch, errind);

    errind->er_ret = ftam_wait_request(ch, FTI_BULKBEGIN, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_start_bulk_get");
	return;
    }
    /* FTI_BULKBEGIN */
    {
	struct FTAMgroup *ftg = &errind->er_fti.fti_group;
	int	    state;
	struct FTAMgroup    ftms;
	struct FTAMgroup   *ftm = &ftms;
	
	*ftm = *ftg;
	
	errind->er_ret = FBulkBeginResponse (ch, ftm, &errind->er_fti);
	if (errind->er_ret == NOTOK) {
	    errind->er_tag = ERT_FTI;
	    pprintf(EF_IN3, COMMUNICATION, "FBulkBeginResponse",
		   "ftam_await_start_bulk_get");
	    return;
	}
	
	FTGFREE (ftg);
	}

    /* Expect an FReadWriteIndication */

    errind->er_ret = ftam_wait_request(ch, FTI_READWRITE, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_start_bulk_get");
	return;
    }
    /* FTI_READWRITE */
    {
    	struct FTAMreadwrite *ftrw = &errind->er_fti.fti_readwrite;
	int	    result;
	register struct FADUidentity *fa = &ftrw->ftrw_identity;
	struct FTAMdiagnostic   diags[NFDIAG];
	struct FTAMdiagnostic *dp = diags;
	struct FTAMindication   ftis;
	register struct FTAMindication *fti = &ftis;
	
	FTRWFREE (ftrw);
    }

    errind->er_ret = OK;
 	
} /* ftam_await_start_bulk_get */

/*  */

ftam_await_stop_bulk_get(ch, errind)
    channel_t ch;
    error_t *errind;
{

    pprintf("ftam_await_stop_bulk_get(%d, 0x%x)\n", ch, errind);

    errind->er_ret = FDataEndRequest (ch, FACTION_SUCCESS,
				      (struct FTAMdiagnostic *) 0, 0,
				      &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FDataEndRequest",
	       "ftam_await_stop_bulk_get");
	errind->er_tag = ERT_FTI;
	return;
    }

    /* expecting FTransEnd */
    
    errind->er_ret = ftam_wait_request(ch, FTI_TRANSEND, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_stop_bulk_get");
	return;
    }
    /* FTransEnd */
    {
	struct FTAMtransend *ftre = &errind->er_fti.fti_transend;
	
	errind->er_ret = FTransEndResponse (ch, FACTION_SUCCESS,
			       (struct FTAMdiagnostic *) 0, 0, &errind->er_fti);
	if (errind->er_ret == NOTOK) {
	    pprintf(EF_IN3, COMMUNICATION, "FTransEndResponse",
		   "ftam_await_stop_bulk_get");
	    errind->er_tag = ERT_FTI;
	    return;
	}

    }
    
    /* Expecting FBulkEnd */
    
    errind->er_ret = ftam_wait_request(ch, FTI_BULKEND, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_stop_bulk_get");
	return;
    }
    /* FTI_BULKEND */
    {
	struct FTAMgroup *ftg = &errind->er_fti.fti_group;
	struct FTAMgroup    ftms;
	struct FTAMgroup   *ftm = &ftms;
	struct FTAMindication   ftis;
	register struct FTAMindication *fti = &ftis;

	*ftm = *ftg;
	
	errind->er_ret = FBulkEndResponse (ch, ftm, &errind->er_fti);
	if (errind->er_ret == NOTOK) {
	    pprintf(EF_IN3, COMMUNICATION, "FBulkEndResponse",
		   "ftam_await_stop_bulk_get");
	    errind->er_tag = ERT_FTI;
	    return;
	}
	
	FTGFREE (ftg);

    }
    errind->er_ret = OK;
    
} /* ftam_await_stop_bulk_get */

/*  */

ftam_start_bulk_put(ch, errind)
    channel_t ch;
    error_t *errind;
{
    struct FTAMgroup ftgs, *ftg = &ftgs;
    struct FADUidentity faduids;
    struct FADUidentity   *faduid = &faduids;

    pprintf("ftam_start_bulk_put(%d, 0x%x)\n", ch, errind);

    bzero ((char *) ftg, sizeof *ftg);
    ftg->ftg_flags |= FTG_BEGIN | FTG_END;
    ftg->ftg_threshold = 0;

    ftg->ftg_flags |= FTG_SELECT;
    {
	register struct FTAMselect *ftse = &ftg->ftg_select;
	register struct FTAMattributes *fa = &ftse->ftse_attrs;

	fa->fa_present = FA_FILENAME;
	fa->fa_nfile = 0;
#ifdef notdef
	fa->fa_files[fa->fa_nfile++] = src;
#endif notdef
	ftse->ftse_access = FA_PERM_REPLACE;
	FCINIT (&ftse->ftse_conctl);
    }
    ftg->ftg_threshold++;

    ftg->ftg_flags |= FTG_OPEN;
    {
	register struct FTAMopen *ftop = &ftg->ftg_open;

	ftop->ftop_mode = FA_PERM_REPLACE;
	ftop->ftop_contents = vfs[VF_INDEX].vf_oid;
	FCINIT (&ftop->ftop_conctl);
	ftop->ftop_conctl.fc_replacelock = FLOCK_EXCLUSIVE;
    }
    ftg->ftg_threshold++;

    errind->er_ret = FBulkBeginRequest (ch, ftg, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FBulkBeginRequest", 
	       "ftam_start_bulk_put");
	errind->er_tag = ERT_FTI;
	return;
    }

    ftg = &errind->er_fti. fti_group;

    if (ftg->ftg_flags & FTG_SELECT) {
	register struct FTAMselect *ftse = &ftg->ftg_select;

	ftam_diag (ftse->ftse_diags, ftse->ftse_ndiag, 1,
		ftse->ftse_action);
	if (ftse->ftse_state != FSTATE_SUCCESS) {
	    eprintf(EF_IN4X, COMMUNICATION, "FBulkBeginRequest",
		   "ftam_start_bulk_put", "FTAMselect has non-FSTATE_SUCCESS");
 	    errind->er_ret = NOTOK;
	    errind->er_tag = ERT_NONE;
	    FTGFREE (ftg);
	    return;
	}
    }

    if (ftg->ftg_flags & FTG_OPEN) {
	register struct FTAMopen *ftop = &ftg->ftg_open;

	ftam_diag (ftop->ftop_diags, ftop->ftop_ndiag, 1,
		ftop->ftop_action);
	if (ftop->ftop_state != FSTATE_SUCCESS) {
	    eprintf(EF_IN4X, COMMUNICATION, "FBulkBeginRequest",
		   "ftam_start_bulk_put", "FTAMopen has non-FSTATE_SUCCESS");
 	    errind->er_ret = NOTOK;
	    errind->er_tag = ERT_NONE;
	    FTGFREE (ftg);
	    return;
	}
    }

    FTGFREE (ftg);

    faduid->fa_type = FA_FIRSTLAST;
    faduid->fa_firstlast = FA_FIRST;

    errind->er_ret = FReadWriteRequest (ch, FA_OPS_REPLACE, faduid,
					vfs[VF_INDEX].vf_context, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FReadWriteRequest",
	       "ftam_start_bulk_put");
	errind->er_tag = ERT_FTI;
	return;
    }

} /* ftam_start_bulk_put */

/*  */

ftam_stop_bulk_put(ch, errind)
    channel_t ch;
    error_t *errind;
{
    struct FTAMgroup ftgs, *ftg = &ftgs;

    pprintf("ftam_stop_bulk_put(%d, 0x%x)\n", ch, errind);

    errind->er_ret = FDataEndRequest (ch, FACTION_SUCCESS,
				      (struct FTAMdiagnostic *) 0, 0,
				      &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FDataEndRequest",
	       "ftam_await_stop_bulk_put");
	errind->er_tag = ERT_FTI;
	return;
    }

    errind->er_ret = FTransEndRequest (ch, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FTransEndRequest",
	       "ftam_stop_bulk_put");
	errind->er_tag = ERT_FTI;
	return;
    }

    switch (errind->er_fti. fti_type) {
	case FTI_TRANSEND:
	    {
		register struct FTAMtransend *ftre = &errind->er_fti. fti_transend;

		ftam_diag (ftre->ftre_diags, ftre->ftre_ndiag, 1,
			ftre->ftre_action);
	    }
	    break;

	case FTI_CANCEL:
	    {
		register struct FTAMcancel *ftcn = &errind->er_fti. fti_cancel;
		
		pprintf(EF_IN4X, COMMUNICATION, "FTransEndRequest",
		       "ftam_stop_bulk_put", "data transfer canceled!");
		ftam_diag (ftcn->ftcn_diags, ftcn->ftcn_ndiag, 1, 
			ftcn->ftcn_action);

		errind->er_ret = FCancelResponse (ch, FACTION_SUCCESS,
			    (struct FTAMdiagnostic *) 0, 0, &errind->er_fti);
		if (errind->er_ret == NOTOK) {
		    errind->er_tag = ERT_FTI;
		    pprintf(EF_IN3, COMMUNICATION, "FCancelResponse",
			   "ftam_stop_bulk_put");
		}
	    }
	    break;

	default: {
	    eprintf(EF_IN4X, COMMUNICATION, "FTransEndRequest",
		   "ftam_stop_bulk_put",
		   "unexpected indication type");
	    errind->er_ret = NOTOK;
	    errind->er_tag = ERT_NONE;
	    return;
	}
    }

done_transfer: ;
    ftg = &ftgs;
    bzero ((char *) ftg, sizeof *ftg);
    ftg->ftg_flags |= FTG_BEGIN | FTG_END;
    ftg->ftg_threshold = 0;

    ftg->ftg_flags |= FTG_CLOSE;
    ftg->ftg_threshold++;

    ftg->ftg_flags |= FTG_DESELECT;
    ftg->ftg_threshold++;

    errind->er_ret = FBulkEndRequest (ch, ftg, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FBulkEndRequest", "ftam_stop_bulk_put");
	errind->er_tag = ERT_FTI;
	return;
    }

    ftg = &errind->er_fti. fti_group;

    if (ftg->ftg_flags & FTG_CLOSE) {
	register struct FTAMclose     *ftcl = &ftg->ftg_close;

	ftam_diag (ftcl->ftcl_diags, ftcl->ftcl_ndiag, 1,
		ftcl->ftcl_action);
    }

    if (ftg->ftg_flags & FTG_DESELECT) {
	register struct FTAMdeselect   *ftde = &ftg->ftg_deselect;

	ftam_diag (ftde->ftde_diags, ftde->ftde_ndiag, 1,
		ftde->ftde_action);
	ftam_chrg (&ftde->ftde_charges);
    }

    FTGFREE (ftg);
    errind->er_ret = OK;
} /* ftam_stop_bulk_put */

/*  */

ftam_await_start_bulk_put(ch, errind)
    channel_t ch;
    error_t *errind;
{

    pprintf("ftam_await_start_bulk_put(%d, 0x%x)\n", ch, errind);

    errind->er_ret = ftam_wait_request(ch, FTI_BULKBEGIN, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_stop_bulk_put");
	return;
    }
    /* FTI_BULKBEGIN */
    {
	struct FTAMgroup *ftg = &errind->er_fti.fti_group;
	int	    state;
	struct FTAMgroup    ftms;
	struct FTAMgroup   *ftm = &ftms;
	
	*ftm = *ftg;
	
	errind->er_ret = FBulkBeginResponse (ch, ftm, &errind->er_fti);
	if (errind->er_ret == NOTOK) {
	    errind->er_tag = ERT_FTI;
	    pprintf(EF_IN3, COMMUNICATION, "FBulkBeginResponse",
		   "ftam_await_start_bulk_put");
	    return;
	}
	
	FTGFREE (ftg);
	}

    /* Expect an FReadWriteIndication */

    errind->er_ret = ftam_wait_request(ch, FTI_READWRITE, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_start_bulk_put");
	return;
    }
    /* FTI_READWRITE */
    {
    	struct FTAMreadwrite *ftrw = &errind->er_fti.fti_readwrite;
	int	    result;
	register struct FADUidentity *fa = &ftrw->ftrw_identity;
	struct FTAMdiagnostic   diags[NFDIAG];
	struct FTAMdiagnostic *dp = diags;
	struct FTAMindication   ftis;
	register struct FTAMindication *fti = &ftis;
	
	FTRWFREE (ftrw);
    }

    errind->er_ret = OK;

} /* ftam_await_start_bulk_put */

/*  */

ftam_await_stop_bulk_put(ch, errind)
    channel_t ch;
    error_t *errind;
{

    pprintf("ftam_await_stop_bulk_put(%d, 0x%x)\n", ch, errind);

    errind->er_ret = ftam_wait_request(ch, FTI_DATAEND, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_stop_bulk_put");
	return;
    }
    /* expecting FTransEnd */
    
    errind->er_ret = ftam_wait_request(ch, FTI_TRANSEND, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_stop_bulk_put");
	return;
    }
    /* FTransEnd */
    {
	struct FTAMtransend *ftre = &errind->er_fti.fti_transend;
	
	errind->er_ret = FTransEndResponse (ch, FACTION_SUCCESS,
			       (struct FTAMdiagnostic *) 0, 0, &errind->er_fti);
	if (errind->er_ret == NOTOK) {
	    pprintf(EF_IN3, COMMUNICATION, "FTransEndResponse",
		   "ftam_await_stop_bulk_put");
	    errind->er_tag = ERT_FTI;
	    return;
	}

    }
    
    /* Expecting FBulkEnd */
    
    errind->er_ret = ftam_wait_request(ch, FTI_BULKEND, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	pprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_stop_bulk_put");
	return;
    }
    /* FTI_BULKEND */
    {
	struct FTAMgroup *ftg = &errind->er_fti.fti_group;
	struct FTAMgroup    ftms;
	struct FTAMgroup   *ftm = &ftms;
	struct FTAMindication   ftis;
	register struct FTAMindication *fti = &ftis;

	*ftm = *ftg;
	
	errind->er_ret = FBulkEndResponse (ch, ftm, &errind->er_fti);
	if (errind->er_ret == NOTOK) {
	    pprintf(EF_IN3, COMMUNICATION, "FBulkEndResponse",
		   "ftam_await_stop_bulk_put");
	    errind->er_tag = ERT_FTI;
	    return;
	}
	
	FTGFREE (ftg);

    }
    errind->er_ret = OK;
} /* ftam_await_stop_bulk_put */

/*  */

/*
 * Stolen from isode/3.0/ftam2/ftamuser.c
 */
struct vfsmap vfs[] = {
/* VFS_DEF */
    "default", NULLOID, VF_NULL, 0, 0, ' ', NULLIFP, VFS_XXX, 0, NULLCP,
/* bench */
    "FTAM-3",  NULLOID, VF_WARN, 3, 0, ' ', NULLIFP, VFS_XXX,
	FA_ACC_UA, "benchmark data",

#ifdef notdef
/* bench2 */
    "FTAM-3",  NULLOID, VF_WARN, 0, 0, ' ', NULLIFP, VFS_XXX,
	FA_ACC_US, "benchmark data 2",
#endif

/* VFS_UAF */
    "NBS-2",  NULLOID, VF_NULL, 0, 0, 'a', NULLIFP, 1,
	FA_ACC_US, "unstructured IA5 text file",

#ifdef notdef
/* VFS_UAF */
    "NBS-2",  NULLOID, VF_NULL, 0, S_IFREG, 'a', asciicheck, VFS_UBF,
	FA_ACC_US, "unstructured IA5 text file",
/* VFS_UTF */
    "NBS-3",  NULLOID, VF_WARN, 0, S_IFREG, 't', latincheck, VFS_UBF,
	FA_ACC_US, "unstructured 8859/1 text file",

/* VFS_FDF */
    "NBS-9",  NULLOID, VF_NULL, 0, S_IFDIR, 'd', NULLIFP, VFS_XXX,
	FA_ACC_UA, "file directory file",

#endif notdef
    NULL
};

/*  */

/*
 * Stolen from isode/3.0/ftam2/ftamuser.c
 */

static char *entity[] = {
    "unknown",
    "initiator",
    "initiator's FPM",
    "virtual filestore",
    "responder's FPM",
    "responder"
};

void	ftam_diag (diag, ndiag, peer, action)
struct FTAMdiagnostic diag[];
int	ndiag;
int	peer,
	action;
{
    register int    i;
    int     didit;
    register struct FTAMdiagnostic *dp;

    for (dp = diag, i = ndiag - 1; i >= 0; dp++, i--) {
	if (dp->ftd_identifier != FS_GEN_NOREASON) {
	    printf ("%s", FErrString (dp->ftd_identifier));
	    if (dp->ftd_cc > 0)
		printf (": %*.*s", dp->ftd_cc, dp->ftd_cc, dp->ftd_data);
	}
	else
	    if (dp->ftd_cc > 0)
		printf ("%*.*s", dp->ftd_cc, dp->ftd_cc, dp->ftd_data);

	printf ("\n");

	didit = 0;
	switch (dp->ftd_type) {
	    case DIAG_INFORM: 
		if (action == FACTION_SUCCESS)
		    break;
		didit++;
		printf ("    type informative");
		break;

	    case DIAG_TRANS: 
		didit++;
		printf ("    type transient");
		break;

	    case DIAG_PERM: 
		if (dp->ftd_observer == EREF_IFSU)
/*		    ftamfd = NOTOK */ ; 
		if (action != FACTION_SUCCESS)
		    break;
		didit++;
		printf ("    type permanent");
		break;

	    default: 
		didit++;
		printf ("    type %d", dp->ftd_type);
		break;
	}

	switch (dp->ftd_observer) {
	    case EREF_IFSU: 
		goto print_it;

	    case EREF_IFPM: 
		if (peer)
		    goto print_it;
		break;

	    case EREF_RFSU: 
		if (peer)
		    break;	/* else fall */
	    case EREF_RFPM: 
	print_it: ;
		printf ("%sobserver %s", didit++ ? ", " : "    ",
			entity[dp->ftd_observer]);
		break;

	    default: 
		printf ("%sobserver %d", didit++ ? ", " : "    ",
			dp->ftd_observer);
		break;
	}

	switch (dp->ftd_source) {
	    case EREF_NONE: 
	    case EREF_IFSU: 
		break;

	    case EREF_SERV: 
	    case EREF_RFSU: 
		if (peer)
		    break;	/* else fall */
	    case EREF_IFPM: 
	    case EREF_RFPM: 
		printf ("%ssource %s", didit++ ? ", " : "    ",
			entity[dp->ftd_source]);
		break;

	    default: 
		printf ("%ssource %d", didit++ ? ", " : "    ",
			dp->ftd_source);
		break;
	}

	if (dp->ftd_delay != DIAG_NODELAY)
	    printf ("%ssuggested-delay %d", didit++ ? ", " : "    ",
		    dp->ftd_delay);

	if (didit)
	    printf ("\n");
    }
} /* ftam_diags */

/*  */

void	ftam_chrg (charges)
register struct FTAMcharging *charges;
{
    register int    i;
    char   *cp;
    register struct fc_charge  *fc;

    cp = "charging information:\n    %s: %d %s\n";
    for (fc = charges -> fc_charges, i = charges -> fc_ncharge - 1;
	    i >= 0;
	    fc++, i--, cp = "    %s: %d %s\n")
	printf (cp, fc -> fc_resource, fc -> fc_value, fc -> fc_unit);
} /* ftam_chrg */

/*  */

/* ARGSUSED */

static	ftam_finishindication (ch, ftf)
	channel_t ch;
	struct FTAMfinish *ftf;
{
    struct FTAMcharging fcs;
    register struct FTAMcharging   *fc = &fcs;
    struct FTAMindication   ftis;
    register struct FTAMindication *fti = &ftis;


    fc->fc_ncharge = 0;

    if (FTerminateResponse (ch, fc, fti) == NOTOK) {
	struct FTAMabort *fta = &fti->fti_abort;
	
	pprintf(EF_IN3, COMMUNICATION, "FTerminateResponse",
	       "ftam_finishindication");
	ftam_diag(fta->fta_diags, fta->fta_ndiag, fta->fta_peer,
		fta->fta_action);
    }

} /* ftam_finishindication */

/*  */

int	ftam_cancelindication (ch, ftcn)
    channel_t ch;
    struct FTAMcancel *ftcn;
{
    struct FTAMindication   ftis;
    register struct FTAMindication *fti = &ftis;

    pprintf("F-CANCEL.INDICATION: %d", ftcn -> ftcn_action);
    ftam_diag (ftcn -> ftcn_diags, ftcn -> ftcn_ndiag);

    if (FCancelResponse (ch, FACTION_SUCCESS, (struct FTAMdiagnostic *) 0,
		0, fti) == NOTOK) {
	struct FTAMabort *fta = &fti->fti_abort;
	
	pprintf(EF_IN3, COMMUNICATION, "FTerminateResponse",
	       "ftam_finishindication");
	ftam_diag(fta->fta_diags, fta->fta_ndiag, fta->fta_peer,
		fta->fta_action);
    }
} /* ftam_cancelindication */

/*  */

static ftam_abortindication (ch, fta)
    channel_t ch;
    register struct FTAMabort *fta;
{
    ftam_diag (fta->fta_diags, fta->fta_ndiag);

    if (fta->fta_action == FACTION_PERM)
	return;
    else
	if (!fta->fta_peer) {
	    struct FTAMindication   ftis;

	    (void) FUAbortRequest (ch, FACTION_PERM,
		    (struct FTAMdiagnostic *) 0, 0, &ftis);

	     return;
	}
} /* ftam_abortindication */

/*  */

int ftam_wait_request(ch, expected, secs, fti)
    channel_t ch;
    int expected;	/* indication type */
    int secs;		/* INF_WAIT => forever */
    struct FTAMindication *fti;
{
    pprintf("ftam_wait_request(%d, &d, %d, 0x%x)\n", ch, expected, secs, fti);

    if (FWaitRequest(ch, secs, fti) == NOTOK) {
	pprintf(EF_IN3, COMMUNICATION, "FWaitRequest",
	       "ftam_wait_request");
	return NOTOK;
    }

    if (fti->fti_type == expected)
	return OK;
    
    switch (fti->fti_type) {
    case FTI_FINISH:
	pprintf(EF_IN3, COMMUNICATION, "FWaitRequest",
	       "ftam_wait_request");
	pprintf("\tBad indication type: FTI_FINISH\n");
	(void)ftam_finishindication(ch, fti->fti_finish);
	return NOTOK;
	
    case FTI_ABORT:
	pprintf(EF_IN3, COMMUNICATION, "FWaitRequest",
	       "ftam_wait_request");
	pprintf("\tBad indication type: FTI_ABORT\n");
	(void)ftam_abortindication(ch, fti->fti_finish);
	return NOTOK;

    case FTI_CANCEL:
	pprintf(EF_IN3, COMMUNICATION, "FWaitRequest",
	       "ftam_wait_request");
	pprintf("\tBad indication type: FTI_CANCEL\n");
	(void)ftam_cancelindication(ch, fti->fti_finish);
	return NOTOK;

    default:
	pprintf(EF_IN3, COMMUNICATION, "FWaitRequest",
	       "ftam_wait_request");
	pprintf("\tBad indication type: %d\n", fti->fti_type);
	return NOTOK;
    }
    /* NOTREACED */
} /* ftam_wait_request */
    
