/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Address specific code: addresses being socket + port number + program number
 */

#include <general.h>
#include <protospec.h>
#include "../protoaddrs/sunrpcaddr.h"



#define MAXADDRLEN 128




char *address2str(addr, a_len)
    struct address_t *addr;
    int *a_len;
{
    char *str, *res;
    int len;
    static char buf[MAXADDRLEN];
    
    pprintf("address2str(%#x, %#x)\n",
		addr, a_len);;
    
    str = buf;
    sprintf(str, "%d 0x%lx %d 0x%lx\n", addr->addr.sin_family,
	    htonl(addr->addr.sin_addr.s_addr),
	    htons(addr->addr.sin_port),
	    addr->prognum);
    len = strlen(str);
    if (len >= MAXADDRLEN) {
	pprintf(EF_IN3, INTERNAL, "buffer overflow", "address2str");
	return NULL;
    }

    len++;	/* include NULL char */
    res = (char *)malloc(len);
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "address2str",
		"malloc failed");
	return NULL;
    }

    bcopy(buf, res, len);

    *a_len = len;

    pprintf("<address2str: %s.\n", res);

    return res;
} /* address2str */

/*  */




struct address_t *str2address(str, a_len)
    char *str;
    int *a_len;
{
    int len = *a_len;	/* total length */
    int used;		/* used (read) length */
    static struct address_t addrs;	/* Should be initialized to all zeros */
    struct address_t *addr = &addrs, *res;
    char *this, *next;

    pprintf("str2address(%#x, %#x, len %d)\n", str, a_len, *a_len);

    this = str;
    addr->addr.sin_family = strtol(this, &next, 10);
    if (next == this)
	goto err;
    this = next;
    addr->addr.sin_addr.s_addr = ntohl(strtol(this, &next, 0));
    if (next == this)
	goto err;
    this = next;
    addr->addr.sin_port = ntohs(strtol(this, &next, 10));
    if (next == this)
	goto err;
    this = next;
    addr->prognum = strtol(this, &next, 0);
    if (next == this)
	goto err;
    
    res = (struct address_t *) malloc(sizeof(struct address_t));
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "str2address",
		"malloc failed");
	return NULL;
    }
    used = next - str;

    *res = *addr;
    *a_len = used;

    pprintf("<str2address PROGNR: %#x IP: %#x, FAMILY: %d, PORT: %d.\n",
	    res->prognum, res->addr.sin_addr.s_addr, res->addr.sin_family,
	    res->addr.sin_port);
    return res;
    
err:
    pprintf(EF_IN3, INTERNAL, PROTOCOL, "str2address");
    return NULL;
} /* str2address */

/*  */





void address_free(addr)
    struct address_t *addr;
{
    pprintf("address_free(0x%x)\n", addr);

    free((char *)addr);
} /* address_free */








struct address_t *address_copy(addr)
    struct address_t *addr;
{
    struct address_t *res;

    pprintf("address_copy(0x%x)\n", addr);
    res = (struct address_t *) malloc(sizeof(struct address_t));
    if (res == NULL) {
	pprintf(EF_IN4X, INTERNAL, RESOURCE, "address_copy",
		"malloc failed");
	return NULL;
    }

    *res = *addr;
    return res;
} /* address_copy */
