/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * String address type specific code
 */

#ifndef lint
static char
 rcsid[] = "$Header: /usr/share/src/nuada2/SpimsDir/new/protoaddrs/RCS/stringaddr.c,v 1.4 89/06/06 17:39:09 erikn Exp $";
#endif /* not lint */

#include <general.h>
#include <protospec.h>
#include "../protoaddrs/stringaddr.h"

char *address2str(addr, len)
struct address_t *addr;
int *len;
{
  char *str;

  pprintf("address2str(addr %s, length 0x%x)\n", addr->a, len);

  *len = strlen(addr->a) + 1;	/* Including trailing NUL */
  str = (char *) malloc(*len);
  if (str == NULL) {
    eprintf(EF_IN3, INTERNAL, RESOURCE, "address2str");
    return NULL;
  }
  strcpy(str, addr->a);

  pprintf("<address2str:%s, length = %d.\n", str, *len);
  return str;
}


struct address_t *str2address(str,len)
char *str;
int *len;			/* Ignored */
{
  struct address_t *addr;

  pprintf("str2address(str %s, length %d)\n", str, *len);

  addr = (struct address_t *) malloc(sizeof(struct address_t));
  if (addr == NULL) {
    eprintf(EF_IN3, INTERNAL, RESOURCE, "str2address");
    return NULL;
  }
  strcpy(addr->a, str);

  pprintf("<str2address:%s.\n", addr->a);
  return addr;
}


struct address_t *addresscopy(addr)
struct address_t *addr;
{
  struct address_t *addr2;

  addr2 = (struct address_t *) malloc(sizeof(struct address_t));
  if (addr2 == NULL) {
    eprintf(EF_IN3, INTERNAL, RESOURCE, "addresscopy");
    return NULL;
  }
  *addr2 = *addr;			/* struct copy */

  pprintf("addresscopy(addr %s) => %s.\n", addr->a, addr2->a);
  return addr2;
}

void address_free(addr)
struct address_t *addr;
{
  if (addr != NULL)
    free((char *)addr);
}
