/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring one-way bulk data transfer
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>


int bulk_get(be, addr, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct address_t 	*addr;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    INITIATOR_VARIABLES;
    TIMING_VARIABLES(0);
    channel_t 		ch;

    TIMING_INITIATE(0);

    mprintf("bulk_get(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    ConnRequest(addr, &ch, &error);
    if (failed(&error)) {
	report_error(&error, "ConnRequest");
	return NOTOK;
    }


    INITIATOR_BEFORE_START;
    
    StartMeasurements(mt);

    INITIATOR_AFTER_START;

    BulkGetStart(ch, &error);
    if (failed(&error)) {
	report_error(&error, "BulkGetStart");
	goto abort;
    }
	
    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	INITIATOR_RECVSIZE(msgsize,i);
	BulkGetAwaitDataInd(ch, dsthdl->io_bufptr, msgsize, &error);
	if (failed(&error) && !interupted) {
	    report_error(&error, "BulkGetAwaitDataInd");
	    goto abort;;
	}
	if ((*dsthdl->io_put)(dsthdl, msgsize) == NOTOK) {
	    report_error(NULL, "io_put");
	    goto abort;;
	}
	MetricsAddDatarcvd(mt, msgsize);

	if (interupted)
	    break;
        TIMING_DELAY(0);
    }

    BulkGetStop(ch, &error);
    if (failed(&error) && !interupted) {
	report_error(&error, "BulkGetStop");
	goto abort;
    }
    
    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    DiscRequest(ch, &error);
    if (failed(&error) && !interupted) {
	report_error(&error, "DiscRequest");
	return NOTOK;
    }
    
    return OK;

 abort:
    DiscRequest(ch, &error);
    if (failed(&error)) {
	report_error(&error, "DiscRequest on abort");
    }
    return NOTOK;
    
} /* bulk_get */




