/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The uniform(a, b) distribution
 *
 * Additional parameters are ignored!
 */

#include <general.h>

#define Trace 0

double uniform(pm)
    struct param *pm;
{
    int nparam;
    double a, b;

    tprintf("uniform() called!\n");

    nparam = param_nvalues(pm);
    if (nparam < 2) {
	eprintf(EF_IN4X, SPECIFICATION, "to few parameters",
	       "uniform distribution",
	       "Requires two parameters");
	return 0.0;
    }
    if (nparam > 2) {
	eprintf(EF_IN4X, SPECIFICATION, "to many parameters",
	       "uniform distribution",
	       "Requires two parameters");
    }

    a = param_getvalue(pm, 0);
    b = param_getvalue(pm, 1);

    return (b - a) * bench_rand() + a;
} /* uniform */
	
	
