/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The normal(n, sigma) distribution
 *
 * Negative values are truncated to 0!!!
 *
 * Additional parameters are ignored!
 */

#include <general.h>

#define Trace 0

double normal(pm)
    struct param *pm;
{
    double res, n, sigma;
    int nparam;
    
    tprintf("normal() called!\n");

    nparam = param_nvalues(pm);
    if (nparam < 2) {
	eprintf(EF_IN4X, SPECIFICATION, "to few parameters",
	       "normal distribution",
	       "Requires two parameters");
	return 0.0;
    }
    if (nparam > 2) {
	eprintf(EF_IN4X, SPECIFICATION, "to many parameters",
	       "normal distribution",
	       "Requires two parameters");
    }

    n = param_getvalue(pm, 0);
    sigma = param_getvalue(pm, 1);

    compute normally distributed value;

    if (res < 0)
	res = 0;
    return res;
} /* normal */
	
	
