/*
 * Decompiled with CFR 0.152.
 */
package com.jxcell.server.image.plugins;

import com.jxcell.server.image.plugins.J;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;

public abstract class B
implements ImageObserver {
    public int Width;
    public int Height;
    public int Depth = 16;
    public J colorTable;
    public boolean isHILO = false;
    public OutputStream stream;
    private int[] append = null;
    private boolean charAt = false;

    public final void saveToFile(Image image, String string, int n, boolean bl) {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.saveToStream(image, n, fileOutputStream, bl);
        fileOutputStream.close();
    }

    public final byte[] getBytes(Image image, int n, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8096);
        this.saveToStream(image, n, byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public abstract void saveToStream(Image var1, int var2, OutputStream var3, boolean var4);

    public final int[] grab(Image image, int n) {
        image = this.scaled(image, n);
        this.Width = image.getWidth(this);
        this.Height = image.getHeight(this);
        if (this.append == null || this.append.length < this.Width * this.Height || this.charAt) {
            this.append = new int[this.Width * this.Height];
            this.charAt = false;
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.Width, this.Height, this.append, 0, this.Width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("PixelGrab failed: " + interruptedException.getMessage());
        }
        return this.append;
    }

    public final Image scaled(Image image, int n) {
        if (n == 100) {
            return image;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int n4 = (int)Math.round((double)(n2 * n) / 100.0);
        int n5 = (int)Math.round((double)(n3 * n) / 100.0);
        return n2 != n4 || n3 != n5 ? Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new AreaAveragingScaleFilter(n4, n5))) : image;
    }

    public final void writeByte(byte by) {
        this.stream.write(by);
    }

    public final void writeBytes(byte[] byArray) {
        this.stream.write(byArray);
    }

    public final void writeBytes(byte[] byArray, int n, int n2) {
        this.stream.write(byArray, n, n2);
    }

    public final void writeWords(short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            this.writeWord(sArray[i]);
        }
    }

    public final void writeLongs(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.writeLong(nArray[i]);
        }
    }

    public final void writeString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.writeByte((byte)string.charAt(i));
        }
    }

    public final void write(byte by) {
        this.writeByte(by);
    }

    public final void writeWord(int n) {
        if (this.isHILO) {
            this.writeByte((byte)(n >> 8 & 0xFF));
            this.writeByte((byte)(n & 0xFF));
        } else {
            this.writeByte((byte)(n & 0xFF));
            this.writeByte((byte)(n >> 8 & 0xFF));
        }
    }

    public final void writeLong(int n) {
        if (this.isHILO) {
            this.writeWord(n >> 16 & 0xFFFF);
            this.writeWord(n & 0xFFFF);
        } else {
            this.writeWord(n & 0xFFFF);
            this.writeWord(n >> 16 & 0xFFFF);
        }
    }

    public final boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public boolean isForbidden(String string) {
        return false;
    }

    public final void compressRow(int n, byte[] byArray) {
        int n2 = 8 / this.Depth;
        int n3 = this.Width / n2 * n2;
        n *= this.Width;
        switch (this.Depth) {
            default: {
                break;
            }
            case 4: {
                for (int i = 0; i < n3; i += 2) {
                    byArray[n + (i >> 1)] = (byte)(byArray[n + i] << 4 | byArray[n + i + 1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n3; i += 4) {
                    byArray[n + (i >> 2)] = (byte)(byArray[n + i] << 6 | byArray[n + i + 1] << 4 | byArray[n + i + 2] << 2 | byArray[n + i + 3]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n3; i += 8) {
                    byArray[n + (i >> 3)] = (byte)(byArray[n + i] << 7 | byArray[n + i + 1] << 6 | byArray[n + i + 2] << 5 | byArray[n + i + 3] << 4 | byArray[n + i + 4] << 3 | byArray[n + i + 5] << 2 | byArray[n + i + 6] << 1 | byArray[n + i + 7]);
                }
            }
        }
        this.Depth(n, byArray);
    }

    private void Depth(int n, byte[] byArray) {
        int n2 = 8 / this.Depth;
        int n3 = this.Width / n2;
        int n4 = this.Width % n2;
        int n5 = n3 * n2;
        n3 += n;
        n5 += n;
        if (n4 != 0) {
            int n6 = 0;
            for (int i = 0; i < 8 / this.Depth; ++i) {
                n6 = (byte)(n6 << this.Depth);
                if (i >= n4) continue;
                n6 = (byte)(n6 | byArray[n5++]);
            }
            byArray[n3] = n6;
        }
    }

    private final long EYFN() {
        return new Date().getTime();
    }
}

