#ifndef ERROR_H
#define ERROR_H

#include <string>

namespace Libexcel {

	// Class for error handling

	class Error : public std::exception 
	{
	public:
		enum Err {
			ERR_WORKSHEET_EXIST = 1,
			ERR_INVALIDROWCOL,
			ERR_UNRECOGNISEDCHAR,
			ERR_SYNTAXERROR,
			ERR_NOFUNCTION,
			ERR_INCORRECTNUMARGS,
			ERR_UNKNOWNTOKEN,
			ERR_UNKNOWNCLASS,
			ERR_UNKNOWNSHEET,
			ERR_UNKNOWNRANGESEP,
			ERR_INCORRECTFORMAT,
			ERR_INCORRECTDATETIMESTRING,
			ERR_TOOLONGSTRING,
			ERR_IMPORTBITMAP,
			ERR_INVALIDZOOM,
			ERR_UNKNOWNCELLREF,
			ERR_INVALIDCOLORINDEX,
			ERR_INVALIDCOLORCOM,
			ERR_CREATETMPFILE,
			ERR_OPENFILEFORWRITING,
			ERR_INVALIDVALUE,
			ERR_WRITETOFILE,
			ERR_INTERNAL			
		};
		
		Error(Err code, std::string srcname, int srcline, std::wstring message = L"");   // create error object
		virtual ~Error();

		Err code() const { return m_code; }		                                         // get error code
		std::wstring message() const;                                                    // get error message
		std::string srcinfo() const { return m_srcinfo; }                                // system information

	private:
		Err m_code;				
		std::wstring m_message;
		std::string m_srcinfo;		
	};	
}

#endif
