package com.sciapp.demo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import javax.swing.tree.DefaultTreeCellRenderer;

import com.sciapp.table.*;
import com.sciapp.filter.FilterTablePanel;
import com.sciapp.renderers.*;
import com.sciapp.tree.*;
import com.sciapp.filter.*;
/**
 *
 */
public class TreeTableDemoPanel extends AbstractDemoPanel {
	//various
	public GroupingPanel groupPanel;
/**
 *
 */
public TreeTableDemoPanel() {
	super();
}
/**
 *
 */
public TreeTableDemoPanel(ListTableModel dataModel, DataFeeder dataFeeder) {
	super(dataModel, dataFeeder);
}
/**
 *
 */
protected JPanel createTableFeaturePanel() {
	JPanel p = super.createTableFeaturePanel();

	//add a grouping panel
	JPanel rowCompPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
	rowCompPanel.setBorder(new TitledBorder(" Group by "));
	groupPanel = new GroupingPanel((TreeTableModel) model);
	rowCompPanel.add(groupPanel);
	p.add(rowCompPanel);

	return p;
}
/**
 *
 */
protected com.sciapp.table.ListTableModel createTableModel(ListTableModel model) {
	return new TreeTableModel(model);
}
/**
 *
 */
public JPanel createTablePanel(ListTableModel dataModel) {
	JPanel p = super.createTablePanel(dataModel);

	TreeTableModel ttm = (TreeTableModel) model;
	//define the footer and aggregator that will sum over all integer values.
	IntegerSumAggregator isa = new IntegerSumAggregator(ttm.getDefaultAggregator());
	ttm.setFooter(isa);
	ttm.setDefaultAggregator(isa);

	//set yellow color for number aggregate values
	DefaultAggregateRenderer dar = (DefaultAggregateRenderer) ((TreeTable) table).getDefaultAggregateRenderer(Number.class);
	dar.setDefaultLevelBackground(Color.yellow);

	//set some icons for the tree
	JTree tree = ((TreeTable) table).getTree();
	DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer) tree.getCellRenderer();
	java.net.URL url;
	url = getClass().getResource("/folder.gif");
	if (url != null) {
		renderer.setClosedIcon(new ImageIcon(url));
	}
	url = getClass().getResource("/folderO.gif");
	if (url != null) {
		renderer.setOpenIcon(new ImageIcon(url));
	}
	url = getClass().getResource("/leaf.gif");
	if (url != null) {
		renderer.setLeafIcon(new ImageIcon(url));
	}

	return p;
}

/**
 *
 */
protected JTable createTable() {
	return new TreeTable();
}
}
