package com.sciapp.demo;

import com.sciapp.tree.*;
/**
 * This class is both footer and aggregator.
 * It returns sums of integer values for footer rows, otherwise the getAggregateValue method,
 * of the Aggregator supplied in its constructor, is returned.
 */
public class IntegerSumAggregator extends Aggregator implements Footer {
	public Aggregator defaultAggregator;
/**
 *
 */
public IntegerSumAggregator(Aggregator defaultAggregator) {
	super(defaultAggregator.getModel());

	this.defaultAggregator = defaultAggregator;
}
/**
 * For the weight column (4) and for footer rows, sum over all weights in that level and return the value.
 */
public Object getAggregateValue(int rowIndex, int columnIndex) {
	if (columnIndex == 4 && model.isFooter(rowIndex)) {
		TreeTableRow node = model.getTreeRow(rowIndex);
		TreeTableRow parent = (TreeTableRow) node.getParent();

		int[] totalRows = model.getModelIndexesUnderRow(parent, false);
		int sum = 0;
		for (int i = 0; i < totalRows.length; i++) {
			Object val = model.getModel().getRows().get(totalRows[i]);
			Integer iv = (Integer) model.getCellValue(val, columnIndex);
			int ival = iv.intValue();
			sum += ival;
		}
		return new Integer(sum);
	}
	else {
		return defaultAggregator.getAggregateValue(rowIndex, columnIndex);
	}
}
/**
 * Do not return a footer for level 0 rows.
 */
public int getFooterSize(TreeTableRow row) {
	if (row.getLevel() == 0) return 0;
	return 1;
}
}
