/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

public final class OS {
    public static final int JDK1_1 = 11;
    public static final int JDK1_2 = 12;
    public static final int JDK1_3 = 13;
    public static final int JDK1_4 = 14;
    private static boolean isWindows95;
    private static boolean isWindowsNT;
    private static boolean isWindows2000;
    private static boolean isMacintosh;
    private static boolean isSolaris;
    private static boolean isLinux;
    private static boolean isCaseSensitive;
    private static int jdkVersion;

    private OS() {
    }

    public static boolean isWindows() {
        return OS.isWindows95() || OS.isWindowsNT() || OS.isWindows2000();
    }

    public static boolean isWindows95() {
        return isWindows95;
    }

    public static boolean isWindowsNT() {
        return isWindowsNT;
    }

    public static boolean isWindows2000() {
        return isWindows2000;
    }

    public static boolean isMacintosh() {
        return isMacintosh;
    }

    public static boolean isSolaris() {
        return isSolaris;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isUnix() {
        return OS.isSolaris() || OS.isLinux();
    }

    public static boolean isCaseSensitive() {
        return isCaseSensitive;
    }

    public static int getJDKVersion() {
        return jdkVersion;
    }

    public static boolean isOneDotOne() {
        return jdkVersion == 11;
    }

    public static boolean isOneDotTwo() {
        return jdkVersion == 12;
    }

    public static boolean isOneDotThree() {
        return jdkVersion == 13;
    }

    public static boolean isOneDotFour() {
        return jdkVersion == 14;
    }

    public static boolean isOneDotThreeOrMore() {
        return jdkVersion >= 13;
    }

    public static void openDocument(String string) throws Exception {
        if (OS.isWindows2000()) {
            Runtime.getRuntime().exec(new String[]{"cmd /c start", string});
        } else if (OS.isWindows()) {
            Runtime.getRuntime().exec(new String[]{"start", string});
        } else {
            System.err.println("OS.openDocument() not supported on this platform (" + System.getProperty("os.name"));
        }
    }

    static {
        jdkVersion = 11;
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.version").toLowerCase();
        if ("windows nt".equals(string) && "5.0".equals(string2)) {
            isWindows2000 = true;
        } else if (string.equals("windows nt")) {
            isWindowsNT = true;
        } else if (string.startsWith("windows")) {
            isWindows95 = true;
        } else if (string.equals("macintosh") || string.equals("macos") || string.equals("mac os") || string.equals("mac os x")) {
            isMacintosh = true;
        } else if (string.equals("sunos") || string.equals("solaris")) {
            isSolaris = true;
            isCaseSensitive = true;
        } else if (string.equals("linux")) {
            isLinux = true;
            isCaseSensitive = true;
        }
        try {
            Class.forName("java.lang.ref.WeakReference");
            jdkVersion = 12;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("javax.swing.UIDefaults$LazyInputMap");
            jdkVersion = 13;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("java.lang.CharSequence");
            jdkVersion = 14;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

