/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public final class SkinPopupMenuUI
extends BasicPopupMenuUI {
    PopupMenuListener m_PopupListener;
    AncestorListener m_AncestorListener;
    private Skin skin = SkinLookAndFeel.getSkin();

    public void installDefaults() {
        super.installDefaults();
        this.skin.getPersonality().installSkin(this.popupMenu);
        if (Boolean.TRUE.equals(UIManager.get("PopupMenu.animation"))) {
            this.popupMenu.setOpaque(false);
        }
    }

    public void installListeners() {
        super.installListeners();
        if (Boolean.TRUE.equals(UIManager.get("PopupMenu.animation"))) {
            this.m_AncestorListener = new SkinPopupAncestorListener();
            this.popupMenu.addAncestorListener(this.m_AncestorListener);
            this.m_PopupListener = new SkinPopupMenuListener();
            this.popupMenu.addPopupMenuListener(this.m_PopupListener);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AlphaComposite alphaComposite = (AlphaComposite)jComponent.getClientProperty("alpha");
        if (alphaComposite != null) {
            graphics2D.setComposite(alphaComposite);
        }
        this.skin.getPersonality().paintDialog(graphics, jComponent);
        super.paint(graphics, jComponent);
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.popupMenu.setOpaque(true);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.m_AncestorListener != null) {
            this.popupMenu.removeAncestorListener(this.m_AncestorListener);
        }
        if (this.m_PopupListener != null) {
            this.popupMenu.removePopupMenuListener(this.m_PopupListener);
        }
        this.popupMenu.putClientProperty("alpha", null);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SkinPopupMenuUI();
    }

    public JPopupMenu popupMenu() {
        return this.popupMenu;
    }

    class SkinPopupMenuListener
    implements PopupMenuListener {
        Thread popupAnimator = null;

        SkinPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            if (this.popupAnimator != null) {
                this.popupAnimator.interrupt();
            }
            SkinPopupMenuUI.this.popupMenu().putClientProperty("alpha", null);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (this.popupAnimator != null) {
                this.popupAnimator.interrupt();
            }
            SkinPopupMenuUI.this.popupMenu().putClientProperty("alpha", null);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            SkinPopupMenuUI.this.popupMenu().putClientProperty("alpha", AlphaComposite.getInstance(3, 0.0f));
            if (this.popupAnimator != null) {
                this.popupAnimator.interrupt();
            }
            this.popupAnimator = new Thread(this, "PopupAnimator"){
                private final /* synthetic */ SkinPopupMenuListener this$1;
                {
                    this.this$1 = skinPopupMenuListener;
                }

                public void run() {
                    try {
                        AlphaComposite alphaComposite = (AlphaComposite)SkinPopupMenuListener.access$000(this.this$1).popupMenu().getClientProperty("alpha");
                        while (alphaComposite != null && (double)alphaComposite.getAlpha() < 0.75) {
                            Thread.sleep(25L);
                            alphaComposite = AlphaComposite.getInstance(alphaComposite.getRule(), alphaComposite.getAlpha() + 0.05f);
                            SkinPopupMenuListener.access$000(this.this$1).popupMenu().putClientProperty("alpha", alphaComposite);
                            SkinPopupMenuListener.access$000(this.this$1).popupMenu().repaint();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.this$1.popupAnimator = null;
                }
            };
            this.popupAnimator.start();
        }

        static /* synthetic */ SkinPopupMenuUI access$000(SkinPopupMenuListener skinPopupMenuListener) {
            return skinPopupMenuListener.SkinPopupMenuUI.this;
        }
    }

    class SkinPopupAncestorListener
    implements AncestorListener {
        SkinPopupAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Container container = ancestorEvent.getComponent().getParent();
            if (container instanceof JComponent) {
                ((JComponent)container).setDoubleBuffered(false);
                ((JComponent)container).setOpaque(false);
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

