program SoapSubscriberDemo;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  BTJMSClient in '..\..\source\BTJMSClient.pas',
  BTStompInterfaces in '..\..\source\BTStompInterfaces.pas',
  BTActiveMQClient in '..\..\source\BTActiveMQClient.pas',
  BTJMSInterfaces in '..\..\source\BTJMSInterfaces.pas',
  BTStompTypes in '..\..\source\BTStompTypes.pas',
  BTStompConnection in '..\..\source\BTStompConnection.pas',
  BTSupportInterfaces in '..\..\source\BTSupportInterfaces.pas',
  BTCommAdapterIndy in '..\..\source\BTCommAdapterIndy.pas';

const
  Dest = '/queue/a';

type

  TBTJMSSimpleSubscriber = class(TBTJMSClient)
  private
  public
  I: Integer;
  procedure MyOnMessage(Sender: TObject; JMSMessage:
    ITextMessage);
  end;

var
  Conn: TBTJMSSimpleSubscriber;

  L: ILogging;
  Compiler: string;

{ TBTJMSSimpleSubscriber }

procedure TBTJMSSimpleSubscriber.MyOnMessage(Sender: TObject;
  JMSMessage: ITextMessage);
begin
  I := I + 1;
  Logger.Info(Format('Message %d received', [I]));

  if I = 8 then
  begin
    Conn.Disconnect;
  end;
  
end;

begin
  {$IFDEF FPC}
  Compiler := 'Free Pascal';
  {$ELSE}
  Compiler := 'Borland Delphi';
  {$ENDIF}

  Conn := TBTJMSSimpleSubscriber.Create(nil);

  try
    if ParamCount = 1 then
      Conn.Host := ParamStr(1)
    else
      Conn.Host := 'localhost';

    Conn.OnJMSTextMessage := Conn.MyOnMessage;

    L := Conn.Logger;
    L.Info(TBTActiveMQClient.ClassName + ' ' + Conn.Version + ' Compiler: '  + Compiler);
    
    L.Info('Connect to server');
    Conn.Connect;

    Conn.Subscribe(Dest);
    L.Info('Wait for 8 incoming messages');
    Conn.I := 0;

    while Conn.StompConnected do
    begin
       Sleep(50);
    end;

    L.Info('Hit any key');
    ReadLn;

  finally
    Conn.Free;
  end;

end.

