unit OptionsSendFrm;

interface

uses
  BTJMSTextMessage, BTJMSInterfaces, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TOptionsSendForm = class(TForm)
    Label1: TLabel;
    EditCorrelationId: TEdit;
    Label2: TLabel;
    EditExpiration: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    EditPriority: TEdit;
    CbxPersistent: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    Label5: TLabel;
    EditReplyTo: TEdit;
    MemoText: TMemo;
    Label6: TLabel;
    BtnDeSoap: TButton;
    procedure BtnDeSoapClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure InitTextMessage(TM: ITextMessage);
    function GetMessageOptions: ITextMessage;
  end;

var
  OptionsSendForm: TOptionsSendForm;

implementation

uses SendObjectsFrm;



{$R *.dfm}

{ TOptionsSendForm }

procedure TOptionsSendForm.BtnDeSoapClick(Sender: TObject);
var
  SendObjectsForm: TSendObjectsForm;
begin
  Application.CreateForm(TSendObjectsForm, SendObjectsForm);
  try
    SendObjectsForm.MemoXML.Text := MemoText.Text;
    SendObjectsForm.ShowModal;
  finally
    SendObjectsForm.Free;
  end;
end;

function TOptionsSendForm.GetMessageOptions: ITextMessage;
begin
  Result := TBTJMSTextMessage.Create;
  Result.CorrelationID := EditCorrelationId.Text;
  Result.Expiration := StrToIntDef(EditExpiration.Text, 0);
  Result.Persistent := CbxPersistent.Checked;
  Result.Priority := StrToIntDef(EditPriority.Text, 0);
  Result.ReplyTo := EditReplyTo.Text;
end;

procedure TOptionsSendForm.InitTextMessage(TM: ITextMessage);
begin
  EditCorrelationId.Text := TM.CorrelationID;
  EditExpiration.Text := IntToStr(TM.Expiration);
  CbxPersistent.Checked := TM.Persistent;
  EditPriority.Text := IntToStr(TM.Priority);
  EditReplyTo.Text := TM.ReplyTo;
  MemoText.Text := TM.Text;

  BtnDeSoap.Enabled := Pos('<root', TM.Text) = 1;
  
end;

end.
