/*

    Microsoft Windows 3.1
     Puissance 4  1.00
         Nov. 1993

 Author: Didier Barzin 	

 Send suggestions to dbarzin@is1.ulb.ac.be

 */

#include <windows.h>
#include "game.h"

/*-----------------------------*/

long FAR PASCAL MainWndProc (HWND, WORD, WORD, LONG);

/*-----------------------------*/

LPSTR AppName = "Windows Puissance 4";

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow )
{
HWND hwnd;
MSG msg;
WNDCLASS wndclass;

if (!hPrevInstance)
	{
	wndclass.lpszClassName="PUISS4";
	wndclass.hInstance=hInstance;
	wndclass.lpfnWndProc=(WNDPROC)MainWndProc;
	wndclass.hCursor=LoadCursor(hInstance,MAKEINTRESOURCE(2));
	wndclass.hIcon=LoadIcon(hInstance,IDI_APPLICATION);
	wndclass.lpszMenuName="#1";
	wndclass.hbrBackground=COLOR_WINDOW+1;
	wndclass.style=NULL;
	wndclass.cbClsExtra=0;
	wndclass.cbWndExtra=0;

        RegisterClass (&wndclass);
        }

hwnd= CreateWindow (	"PUISS4",
			AppName,
			WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT,
			0,
			CW_USEDEFAULT,
			0,
			NULL,
			NULL,
			hInstance,
			NULL ) ;

ShowWindow(hwnd,nCmdShow);

while (GetMessage(&msg, 0, 0, 0))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	}
		        	
return 0;
}

/*------------------------------*/

int level=3;
int first=PLAYER;
int turn=PLAYER;


HBRUSH hbr[4];

long FAR PASCAL MainWndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{

char *str;
	switch (message)
		{
		case WM_LBUTTONDOWN:
                        if ((turn==PLAYER)&&(!finish()))
			{
			RECT WindowSize;
			GetClientRect (hwnd,&WindowSize);
			if (WindowSize.right!=0)
                        	{
				int i;
				i=(LOWORD(lParam)*7)/WindowSize.right+1;
				if (good(i))
					{
					RECT WindowSize;
					GetClientRect (hwnd,&WindowSize);
					put(i,PLAYER);
					WindowSize.left=WindowSize.right/7*(i-1);
					WindowSize.top=WindowSize.bottom-WindowSize.bottom/6*(game.lastpos[i]);
					WindowSize.right=WindowSize.right/7*i;
					WindowSize.bottom=WindowSize.bottom-WindowSize.bottom/6*(game.lastpos[i]-1);

					InvalidateRect(hwnd,(RECT FAR *)&WindowSize,FALSE);
					if (win(PLAYER))
						{
						MessageBox(hwnd,(LPSTR)"You win !",AppName,MB_OK|MB_ICONEXCLAMATION);
                                                turn=NOBODY;
						}
					else
						{
						turn=COMPUTER;
						SetTimer(hwnd,(UINT)1,(UINT)1,(TIMERPROC)NULL);
						}
					}
				else
					MessageBox(hwnd,(LPSTR)"Invalid Place",AppName,MB_OK|MB_ICONASTERISK);
				}
			}
			break;
		case WM_TIMER:
			if ((turn==COMPUTER)&&(!finish()))
				{
        	                int i;
				RECT WindowSize;
                                KillTimer(hwnd,(UINT)1);
				GetClientRect (hwnd,&WindowSize);
				i=Min_Max(level);
				put(i,COMPUTER);
				WindowSize.left=WindowSize.right/7*(i-1);
				WindowSize.top=WindowSize.bottom-WindowSize.bottom/6*(game.lastpos[i]);
				WindowSize.right=WindowSize.right/7*i;
				WindowSize.bottom=WindowSize.bottom-WindowSize.bottom/6*(game.lastpos[i]-1);
				InvalidateRect(hwnd,(RECT FAR *)&WindowSize,FALSE);
                		if (win(COMPUTER))
					{
					MessageBox(hwnd,(LPSTR)"I win !!!",AppName,MB_OK|MB_ICONEXCLAMATION);
	                	        turn=NOBODY;
					}
				else turn=PLAYER;
			}
                        break;
		case WM_SIZE:
                        {
			InvalidateRect(hwnd,(RECT FAR *)NULL,FALSE);
			}
			break;
		case WM_PAINT:
			{
			PAINTSTRUCT ps;
			RECT WindowSize;
			int i,j;
			BeginPaint (hwnd, &ps);
			SetBkColor(ps.hdc,RGB(0,0,0xff));
			GetClientRect (hwnd,&WindowSize);
			SelectObject(ps.hdc,hbr[0]);
			Rectangle (ps.hdc,0,0,WindowSize.right,WindowSize.bottom);
			for (i=0;i<7;i++)
				for (j=0;j<6;j++)
					{
					if (game.t[i+1][j+1]==PLAYER)
						SelectObject(ps.hdc,hbr[1]);
					else
					if (game.t[i+1][j+1]==COMPUTER)
						SelectObject(ps.hdc,hbr[2]);
					else
						SelectObject(ps.hdc,hbr[3]);
					Ellipse (ps.hdc,
						WindowSize.right/56*(i+1)+WindowSize.right/8*i,
						WindowSize.bottom-(WindowSize.bottom/42*(j+1)+WindowSize.bottom/7*j),
						WindowSize.right/56*(i+1)+WindowSize.right/8*(i+1),
						WindowSize.bottom-(WindowSize.bottom/42*(j+1)+WindowSize.bottom/7*(j+1)));
					}
			EndPaint(hwnd, &ps);
			}
			break;
		case WM_CREATE:
			{
			HMENU hmenu;
			hmenu=GetMenu(hwnd);
			hmenu=GetSubMenu(hmenu,1);
			CheckMenuItem(hmenu,level,MF_BYCOMMAND|MF_CHECKED);
			InitGame();
			hbr[0]=CreateSolidBrush(RGB(0,0,0xff));
			hbr[1]=CreateSolidBrush(RGB(0xBB,0xBB,0x00));
			hbr[2]=CreateSolidBrush(RGB(0xff,0,0));
			hbr[3]=CreateSolidBrush(RGB(0xAA,0xAA,0xAA));
			}
			break;
		case WM_KEYUP:
			{
			if (wParam==VK_F2)
			{
				InitGame();
                                turn=first;
				InvalidateRect(hwnd,(RECT FAR *)NULL,FALSE);
				if (turn==COMPUTER)
					SetTimer(hwnd,(UINT)1,(UINT)1,(TIMERPROC)NULL);
			}
			break;
		case WM_COMMAND:
			if ((wParam>0)&&(wParam<10))
				{
				HMENU hmenu;
				hmenu=GetMenu(hwnd);
				hmenu=GetSubMenu(hmenu,1);
				CheckMenuItem(hmenu,level,MF_BYCOMMAND|MF_UNCHECKED);
				CheckMenuItem(hmenu,wParam,MF_BYCOMMAND|MF_CHECKED);
				level=wParam;
                                break;
				}
			if (wParam==20)
				{
				InitGame();
                                turn=first;
				InvalidateRect(hwnd,(RECT FAR *)NULL,FALSE);
				if (turn==COMPUTER)
					SetTimer(hwnd,(UINT)1,(UINT)1,(TIMERPROC)NULL);
				break;
				}
			if (wParam==21)		// Message
				{
				HMENU hmenu;
				hmenu=GetMenu(hwnd);
				hmenu=GetSubMenu(hmenu,0);
				if (first==COMPUTER)
					{
					ModifyMenu(hmenu,21,MF_BYCOMMAND,21,"Player Begin");
					first=PLAYER;
					}
				else
					{
					ModifyMenu(hmenu,21,MF_BYCOMMAND,21,"Computer Begin");
					first=COMPUTER;
					}
				break;
				}
			if (wParam==22)		// Quit
				{
				PostQuitMessage(0);
        	                break;
				}
			if (wParam==23)
				{
				MessageBox(hwnd,"Microsoft Windows 3.1\n    Puissance 4 Game\t\n         Version 1.00\n\nAuthor: Didier Barzin\n dbarzin@is1.ulb.ac.be",AppName,MB_OK|MB_ICONASTERISK|MB_NOFOCUS);
				break;
				}
			}
			break;
		case WM_DESTROY:
                	{
			int i;
			for (i=0;i<4;i++)
				DeleteObject(hbr[i]);
			PostQuitMessage(0);
			break;
                        }
		default:
			return(DefWindowProc(hwnd,message,wParam,lParam));
		}
return 0L;
}

