/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;

import stec.iws.Request;
import stec.iws.Response;

public class ServletContextTesterServlet extends BaseServlet
{
	public void init(ServletConfig _config) throws ServletException
	{
		super.init(_config);

		ServletContext servlet_context = getServletContext();

		servlet_context.setAttribute("init_key1", "init_value1");
		servlet_context.setAttribute("init_key2", "init_value2");
	}


	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		ServletContext servlet_context = getServletContext();

		String key;
		String value;

		String action = _request.getParameter("action");
		if(action != null)
		{
			if(action.equalsIgnoreCase("set value"))
			{
				key = _request.getParameter("key");
				if(key == null)
				{
					key = "";
				}

				value = _request.getParameter("value");
				if(value == null)
				{
					value = "";
				}

				if(key.length() > 0)
				{
					servlet_context.setAttribute(key, value);
				}
			}
			else if(action.equalsIgnoreCase("remove value"))
			{
				key = _request.getParameter("key");
				if(key == null)
				{
					key = "";
				}

				servlet_context.removeAttribute(key);
			}
			else if(action.equalsIgnoreCase("dump servlet context"))
			{
				String url = _response.encodeRedirectURL("./dumpservletcontext.html");
				_response.sendRedirect(url);
				return;
			}
		}

		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Servlet Context Tester Servlet</title></head>");
		writer.println("<body>");

		writer.println("<h1>Servlet Context Tester Servlet</h1>");

		writer.println("<hr>");

		DumpServletContextServlet.dump_servlet_context(writer, servlet_context);

		writer.println("<hr>");

		writer.println("<form action=\"" + _response.encodeURL("./servletcontexttester.html") + "\" method=\"get\">");
		writer.println("Key: ");
		writer.println("<input type=\"text\" name=\"key\" value=\"\">");
		writer.println("<br>");
		writer.println("Value: ");
		writer.println("<input type=\"text\" name=\"value\" value=\"\">");
		writer.println("<p>");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Set Value\">");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Remove Value\">");
		writer.println("<input type=\"submit\" name = \"action\" value=\"Dump Servlet Context\">");
		writer.println("</form>");

		writer.println("</body>");
		writer.println("</html>");
	}
}
