/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;
import java.io.PrintWriter;

import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.ResultSet;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.ServletConfig;

import stec.iws.Request;
import stec.iws.Response;

public class ListEmployeesServlet extends BaseServlet
{
	Connection connection = null;

	public void init(ServletConfig _config) throws ServletException
	{
		super.init(_config);

		try
		{
			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
			connection = DriverManager.getConnection("jdbc:odbc:iob", "", "");
		}
		catch(Exception ex)
		{
			throw new ServletException(ex.getMessage());
		}
	}

	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>List Employees Servlet</title></head>");
		writer.println("<body>");

		Statement statement = null;
		ResultSet resultSet = null;

		try
		{
			writer.println("<table cellpadding=5 cellspacing=0 border=1>\n");
			writer.println("<tr>\n");
			writer.println("<th>");
			writer.println("First Name");
			writer.println("</th>\n");
			writer.println("<th>");
			writer.println("Last Name");
			writer.println("</th>\n");
			writer.println("<th>");
			writer.println("Title");
			writer.println("</th>\n");
			writer.println("<th>");
			writer.println("Email Address");
			writer.println("</th>\n");
			writer.println("<th>");
			writer.println("Phone Number");
			writer.println("</th>\n");
			writer.println("</tr>\n");

			int count = 0;

			statement = connection.createStatement();
			resultSet = statement.executeQuery("select FirstName, LastName, Title, EmailAddress, PhoneNumber from employees");

			while(resultSet.next())
			{
				writer.println("<tr>\n");
				writer.println("<td>");
				writer.println(resultSet.getString("FirstName"));
				writer.println("</td>\n");
				writer.println("<td>");
				writer.println(resultSet.getString("LastName"));
				writer.println("</td>\n");
				writer.println("<td>");
				writer.println(resultSet.getString("Title"));
				writer.println("</td>\n");
				writer.println("<td>");
				writer.println(resultSet.getString("EmailAddress"));
				writer.println("</td>\n");
				writer.println("<td>");
				writer.println(resultSet.getString("PhoneNumber"));
				writer.println("</td>\n");
				writer.println("</tr>\n");

				count++;
			}

			writer.println("</table>\n");

			if(count == 0)
			{
				writer.println("no employees were displayed");
			}
			else if(count == 1)
			{
				writer.println("1 employee was displayed");
			}
			else
			{
				writer.println(count + " employees were displayed");
			}
		}
		catch(Exception ex)
		{
			throw new ServletException(ex.getMessage());
		}
		finally
		{
			try
			{
				if(resultSet != null)
					resultSet.close();
			}
			catch(Exception ex)
			{
				; // [mjg] ignore
			}

			try
			{
				if(statement != null)
					statement.close();
			}
			catch(Exception ex)
			{
				; // [mjg] ignore
			}
		}

		writer.println("</body>");
		writer.println("</html>");
	}

	public void destroy()
	{
		try
		{
			try
			{
				if(connection != null)
					connection.close();
			}
			catch(Exception ex)
			{
				; // [mjg] ignore
			}
		}
		finally
		{
			super.destroy();
		}
	}
}
